/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.FileHighlighingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class HighlightLevelUtil {
    private HighlightLevelUtil() {
    }

    public static boolean shouldHighlight(@NotNull PsiElement psiRoot) {
        if (psiRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightLevelUtil.shouldHighlight must not be null");
        }
        HighlightingSettingsPerFile component = HighlightingSettingsPerFile.getInstance(psiRoot.getProject());
        if (component == null) {
            return true;
        }
        FileHighlighingSetting settingForRoot = component.getHighlightingSettingForRoot(psiRoot);
        return settingForRoot != FileHighlighingSetting.SKIP_HIGHLIGHTING;
    }

    public static boolean shouldInspect(@NotNull PsiElement psiRoot) {
        if (psiRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightLevelUtil.shouldInspect must not be null");
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!HighlightLevelUtil.shouldHighlight(psiRoot)) {
            return false;
        }
        Project project = psiRoot.getProject();
        VirtualFile virtualFile = psiRoot.getContainingFile().getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile(virtualFile)) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if ((fileIndex.isInLibrarySource(virtualFile) || fileIndex.isInLibraryClasses(virtualFile)) && !fileIndex.isInContent(virtualFile)) {
            return false;
        }
        HighlightingSettingsPerFile component = HighlightingSettingsPerFile.getInstance(project);
        if (component == null) {
            return true;
        }
        FileHighlighingSetting settingForRoot = component.getHighlightingSettingForRoot(psiRoot);
        return settingForRoot != FileHighlighingSetting.SKIP_INSPECTION;
    }

    public static void forceRootHighlighting(@NotNull PsiElement root, @NotNull FileHighlighingSetting level) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightLevelUtil.forceRootHighlighting must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightLevelUtil.forceRootHighlighting must not be null");
        }
        HighlightingSettingsPerFile component = HighlightingSettingsPerFile.getInstance(root.getProject());
        if (component == null) {
            return;
        }
        component.setHighlightingSettingForRoot(root, level);
    }
}

