/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class VariableTypeFix
implements IntentionAction {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix");
    private final PsiVariable myVariable;
    private final PsiType myReturnType;

    public VariableTypeFix(PsiVariable variable, PsiType toReturn) {
        this.myVariable = variable;
        this.myReturnType = toReturn != null ? GenericsUtil.getVariableTypeByExpressionType((PsiType)toReturn) : null;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("fix.variable.type.text", this.getVariable().getName(), this.getReturnType().getCanonicalText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.variable.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix.isAvailable must not be null");
        }
        return this.getVariable() != null && this.getVariable().isValid() && this.getVariable().getManager().isInProject((PsiElement)this.getVariable()) && this.getReturnType() != null && this.getReturnType().isValid() && !TypeConversionUtil.isNullType((PsiType)this.getReturnType()) && !TypeConversionUtil.isVoidType((PsiType)this.getReturnType());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.getVariable().getContainingFile())) {
            return;
        }
        try {
            this.getVariable().normalizeDeclaration();
            this.getVariable().getTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory().createTypeElement(this.getReturnType()));
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)this.getVariable());
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected PsiVariable getVariable() {
        return this.myVariable;
    }

    protected PsiType getReturnType() {
        return this.myReturnType;
    }
}

