/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import org.jetbrains.annotations.NonNls;

public class FoldingTransferableData
implements TextBlockTransferableData,
Serializable {
    private final FoldingData[] myFoldingDatas;

    public FoldingTransferableData(FoldingData[] foldingDatas) {
        this.myFoldingDatas = foldingDatas;
    }

    @Override
    public DataFlavor getFlavor() {
        return FoldingData.getDataFlavor();
    }

    @Override
    public int getOffsetCount() {
        return this.myFoldingDatas.length * 2;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        for (FoldingData data : this.myFoldingDatas) {
            offsets[index++] = data.startOffset;
            offsets[index++] = data.endOffset;
        }
        return index;
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        for (FoldingData data : this.myFoldingDatas) {
            data.startOffset = offsets[index++];
            data.endOffset = offsets[index++];
        }
        return index;
    }

    protected FoldingTransferableData clone() {
        FoldingData[] newFoldingData = new FoldingData[this.myFoldingDatas.length];
        for (int i = 0; i < this.myFoldingDatas.length; ++i) {
            newFoldingData[i] = (FoldingData)this.myFoldingDatas[i].clone();
        }
        return new FoldingTransferableData(newFoldingData);
    }

    public FoldingData[] getData() {
        return this.myFoldingDatas;
    }

    public static class FoldingData
    implements Cloneable,
    Serializable {
        @NonNls
        private static DataFlavor ourFlavor;
        public int startOffset;
        public int endOffset;
        public final boolean isExpanded;

        public FoldingData(int startOffset, int endOffset, boolean expanded) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.isExpanded = expanded;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException();
            }
        }

        public static DataFlavor getDataFlavor() {
            if (ourFlavor != null) {
                return ourFlavor;
            }
            try {
                ourFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + FoldingData.class.getName(), "FoldingData");
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            return ourFlavor;
        }
    }
}

