/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;

public class JoinLinesHandler
extends EditorWriteActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.JoinLinesHandler");
    private final EditorActionHandler myOriginalHandler;

    public JoinLinesHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        if (!(editor.getDocument() instanceof DocumentEx)) {
            this.myOriginalHandler.execute(editor, dataContext);
            return;
        }
        DocumentEx doc = (DocumentEx)editor.getDocument();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = docManager.getPsiFile((Document)doc);
        if (psiFile == null) {
            this.myOriginalHandler.execute(editor, dataContext);
            return;
        }
        int startLine = caretPosition.line;
        int endLine = startLine + 1;
        if (editor.getSelectionModel().hasSelection()) {
            startLine = doc.getLineNumber(editor.getSelectionModel().getSelectionStart());
            endLine = doc.getLineNumber(editor.getSelectionModel().getSelectionEnd());
            if (doc.getLineStartOffset(endLine) == editor.getSelectionModel().getSelectionEnd()) {
                --endLine;
            }
        }
        int caretRestoreOffset = -1;
        for (int i = startLine; i < endLine && i < doc.getLineCount() - 1; ++i) {
            JoinLinesHandlerDelegate delegate;
            int start;
            int lastNonSpaceOffsetInStartLine;
            int firstNonSpaceOffsetInNextLine;
            int lineEndOffset = doc.getLineEndOffset(startLine);
            docManager.commitDocument((Document)doc);
            CharSequence text = doc.getCharsSequence();
            for (firstNonSpaceOffsetInNextLine = doc.getLineStartOffset(startLine + 1); firstNonSpaceOffsetInNextLine < text.length() - 1 && (text.charAt(firstNonSpaceOffsetInNextLine) == ' ' || text.charAt(firstNonSpaceOffsetInNextLine) == '\t'); ++firstNonSpaceOffsetInNextLine) {
            }
            PsiElement elementAtNextLineStart = psiFile.findElementAt(firstNonSpaceOffsetInNextLine);
            boolean isNextLineStartsWithComment = JoinLinesHandler.isCommentElement(elementAtNextLineStart);
            for (lastNonSpaceOffsetInStartLine = lineEndOffset; lastNonSpaceOffsetInStartLine > 0 && (text.charAt(lastNonSpaceOffsetInStartLine - 1) == ' ' || text.charAt(lastNonSpaceOffsetInStartLine - 1) == '\t'); --lastNonSpaceOffsetInStartLine) {
            }
            int elemOffset = lastNonSpaceOffsetInStartLine > doc.getLineStartOffset(startLine) ? lastNonSpaceOffsetInStartLine - 1 : -1;
            PsiElement elementAtStartLineEnd = elemOffset == -1 ? null : psiFile.findElementAt(elemOffset);
            boolean isStartLineEndsWithComment = JoinLinesHandler.isCommentElement(elementAtStartLineEnd);
            if (lastNonSpaceOffsetInStartLine == doc.getLineStartOffset(startLine)) {
                doc.deleteString(doc.getLineStartOffset(startLine), firstNonSpaceOffsetInNextLine);
                int indent = -1;
                try {
                    docManager.commitDocument((Document)doc);
                    indent = CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, startLine == 0 ? 0 : doc.getLineStartOffset(startLine));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if (caretRestoreOffset != -1) continue;
                caretRestoreOffset = indent;
                continue;
            }
            doc.deleteString(lineEndOffset, lineEndOffset + doc.getLineSeparatorLength(startLine));
            text = doc.getCharsSequence();
            int end = lineEndOffset;
            for (start = lineEndOffset - 1; start > 0 && (text.charAt(start) == ' ' || text.charAt(start) == '\t'); --start) {
            }
            while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                ++end;
            }
            docManager.commitDocument((Document)doc);
            int rc = -1;
            JoinLinesHandlerDelegate[] arr$ = (JoinLinesHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)JoinLinesHandlerDelegate.EP_NAME);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (rc = (delegate = arr$[i$]).tryJoinLines((Document)doc, psiFile, start, end)) == -1; ++i$) {
            }
            docManager.doPostponedOperationsAndUnblockDocument((Document)doc);
            if (rc != -1) {
                if (caretRestoreOffset != -1) continue;
                caretRestoreOffset = rc;
                continue;
            }
            if (caretRestoreOffset == -1) {
                int n = caretRestoreOffset = start == lineEndOffset ? start : start + 1;
            }
            if (isStartLineEndsWithComment && isNextLineStartsWithComment) {
                if (text.charAt(end) == '*' && end < text.length() && text.charAt(end + 1) != '/') {
                    ++end;
                    while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                        ++end;
                    }
                } else if (text.charAt(end) == '/') {
                    end += 2;
                    while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                        ++end;
                    }
                }
                doc.replaceString(start == lineEndOffset ? start : start + 1, end, " ");
                continue;
            }
            while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                ++end;
            }
            doc.replaceString(start == lineEndOffset ? start : start + 1, end, " ");
            if (start <= doc.getLineStartOffset(startLine)) {
                try {
                    docManager.commitDocument((Document)doc);
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, doc.getLineStartOffset(startLine));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            int prevLineCount = doc.getLineCount();
            docManager.commitDocument((Document)doc);
            try {
                CodeStyleManager.getInstance((Project)project).reformatText(psiFile, start + 1, end);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            if (prevLineCount < doc.getLineCount()) {
                docManager.doPostponedOperationsAndUnblockDocument((Document)doc);
                start = end - doc.getLineSeparatorLength(startLine);
                int addedLinesCount = doc.getLineCount() - prevLineCount - 1;
                for (end = doc.getLineEndOffset(startLine) + doc.getLineSeparatorLength(startLine); end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t' || text.charAt(end) == '\n' && addedLinesCount > 0); ++end) {
                    if (text.charAt(end) != '\n') continue;
                    --addedLinesCount;
                }
                doc.replaceString(start, end, " ");
            }
            docManager.commitDocument((Document)doc);
        }
        if (editor.getSelectionModel().hasSelection()) {
            editor.getCaretModel().moveToOffset(editor.getSelectionModel().getSelectionEnd());
        } else if (caretRestoreOffset != -1) {
            editor.getCaretModel().moveToOffset(caretRestoreOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
        }
    }

    private static boolean isCommentElement(PsiElement element) {
        return element != null && PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null;
    }
}

