/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.CharArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class PasteHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.PasteHandler");
    private final EditorActionHandler myOriginalHandler;
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.customPasteProvider");

    public PasteHandler(EditorActionHandler originalAction) {
        this.myOriginalHandler = originalAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Editor editor, DataContext dataContext) {
        if (editor.isViewer()) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), (Project)PlatformDataKeys.PROJECT.getData(dataContext))) {
            return;
        }
        Project project = editor.getProject();
        if (project == null || editor.isColumnMode() || editor.getSelectionModel().hasBlockSelection()) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, dataContext);
            }
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, dataContext);
            }
            return;
        }
        FileType fileType = file.getFileType();
        document.startGuardedBlockChecking();
        try {
            for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions(EP_NAME)) {
                if (!provider.isPasteEnabled(dataContext)) continue;
                provider.performPaste(dataContext);
                return;
            }
            PasteHandler.doPaste(editor, project, file, fileType, document);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
        }
        finally {
            document.stopGuardedBlockChecking();
        }
    }

    private static void doPaste(final Editor editor, final Project project, PsiFile file, FileType fileType, Document document) {
        Transferable content = CopyPasteManager.getInstance().getContents();
        if (content != null) {
            String text = null;
            try {
                text = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                editor.getComponent().getToolkit().beep();
            }
            if (text == null) {
                return;
            }
            CodeInsightSettings settings = CodeInsightSettings.getInstance();
            HashMap extraData = new HashMap();
            for (CopyPastePostProcessor processor : (CopyPastePostProcessor[])Extensions.getExtensions(CopyPastePostProcessor.EP_NAME)) {
                TextBlockTransferableData data = processor.extractTransferableData(content);
                if (data == null) continue;
                extraData.put(processor, data);
            }
            text = TextBlockTransferable.convertLineSeparators(text, "\n", extraData.values());
            final int col = editor.getCaretModel().getLogicalPosition().column;
            if (editor.getSelectionModel().hasSelection()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        EditorModificationUtil.deleteSelectedText((Editor)editor);
                    }
                });
            }
            RawText rawText = RawText.fromTransferable((Transferable)content);
            String newText = text;
            for (CopyPastePreProcessor preProcessor : (CopyPastePreProcessor[])Extensions.getExtensions(CopyPastePreProcessor.EP_NAME)) {
                newText = preProcessor.preprocessOnPaste(project, file, editor, newText, rawText);
            }
            int indentOptions = text.equals(newText) ? settings.REFORMAT_ON_PASTE : 4;
            text = newText;
            if (fileType != StdFileTypes.XML && fileType != StdFileTypes.JAVA && indentOptions != 1) {
                indentOptions = 2;
            }
            int length = text.length();
            final String text1 = text;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)text1, (boolean)false, (boolean)true);
                }
            });
            int offset = editor.getCaretModel().getOffset() - length;
            if (offset < 0) {
                length += offset;
                offset = 0;
            }
            final RangeMarker bounds = document.createRangeMarker(offset, offset + length);
            editor.getCaretModel().moveToOffset(bounds.getEndOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            for (Map.Entry e : extraData.entrySet()) {
                ((CopyPastePostProcessor)e.getKey()).processTransferableData(project, editor, bounds, (TextBlockTransferableData)e.getValue());
            }
            final int indentOptions1 = indentOptions;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    switch (indentOptions1) {
                        case 2: {
                            PasteHandler.indentBlock(project, editor, bounds.getStartOffset(), bounds.getEndOffset(), col);
                            break;
                        }
                        case 3: {
                            PasteHandler.indentEachLine(project, editor, bounds.getStartOffset(), bounds.getEndOffset());
                            break;
                        }
                        case 4: {
                            PasteHandler.indentEachLine(project, editor, bounds.getStartOffset(), bounds.getEndOffset());
                            PasteHandler.reformatBlock(project, editor, bounds.getStartOffset(), bounds.getEndOffset());
                        }
                    }
                }
            });
            if (bounds.isValid()) {
                editor.getCaretModel().moveToOffset(bounds.getEndOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
                editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)new TextRange(bounds.getStartOffset(), bounds.getEndOffset()));
            }
        }
    }

    private static void indentBlock(Project project, Editor editor, int startOffset, int endOffset, int originalCaretCol) {
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        boolean hasNewLine = false;
        for (int i = endOffset - 1; i >= startOffset; --i) {
            char c = chars.charAt(i);
            if (c == '\n' || c == '\r') {
                hasNewLine = true;
                break;
            }
            if (c == ' ' || c == '\t') continue;
            return;
        }
        if (!hasNewLine) {
            return;
        }
        int lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)(startOffset - 1), (String)"\n\r") + 1;
        int spaceEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
        if (startOffset <= spaceEnd) {
            if (lineStart != startOffset) {
                String deletedS = ((Object)chars.subSequence(lineStart, startOffset)).toString();
                document.deleteString(lineStart, startOffset);
                startOffset = lineStart;
                document.insertString(endOffset -= deletedS.length(), (CharSequence)deletedS);
                LogicalPosition pos = new LogicalPosition(editor.getCaretModel().getLogicalPosition().line, originalCaretCol);
                editor.getCaretModel().moveToLogicalPosition(pos);
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (LanguageFormatting.INSTANCE.forContext((PsiElement)file) != null) {
                PasteHandler.adjustBlockIndent(project, document, file, startOffset, endOffset);
            } else {
                PasteHandler.indentPlainTextBlock(document, startOffset, endOffset, originalCaretCol);
            }
        }
    }

    private static void indentEachLine(Project project, Editor editor, int startOffset, int endOffset) {
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        endOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(endOffset - 1), (String)"\n\r") + 1;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        try {
            codeStyleManager.adjustLineIndent(file, new TextRange(startOffset, endOffset));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void reformatBlock(Project project, Editor editor, int startOffset, int endOffset) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        try {
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, startOffset, endOffset, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void adjustBlockIndent(Project project, Document document, PsiFile file, int startOffset, int endOffset) {
        FileType fileType = file.getFileType();
        PasteHandler.indentJavaBlock(project, document, startOffset, endOffset, file, fileType);
    }

    private static void indentPlainTextBlock(Document document, int startOffset, int endOffset, int indentLevel) {
        CharSequence chars = document.getCharsSequence();
        int spaceEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
        if (spaceEnd > endOffset) {
            return;
        }
        if (indentLevel == 0) {
            return;
        }
        char[] fill = new char[indentLevel];
        Arrays.fill(fill, ' ');
        String indentString = new String(fill);
        int offset = spaceEnd;
        do {
            document.insertString(offset, (CharSequence)indentString);
        } while ((offset = CharArrayUtil.shiftForwardUntil((CharSequence)(chars = document.getCharsSequence()), (int)offset, (String)"\n") + 1) < (endOffset += indentLevel) && offset < document.getTextLength());
    }

    private static void indentJavaBlock(Project project, Document document, int startOffset, int endOffset, PsiFile file, FileType fileType) {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CharSequence chars = document.getCharsSequence();
        int spaceStart = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)(startOffset - 1), (String)"\n\r") + 1;
        int spaceEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
        if (spaceEnd > endOffset) {
            return;
        }
        while (!codeStyleManager.isLineToBeIndented(file, spaceEnd)) {
            spaceStart = CharArrayUtil.shiftForwardUntil((CharSequence)chars, (int)spaceEnd, (String)"\n\r");
            spaceEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)(spaceStart = CharArrayUtil.shiftForward((CharSequence)chars, (int)spaceStart, (String)"\n\r")), (String)" \t");
            if (spaceEnd < endOffset) continue;
            return;
        }
        Indent indent = codeStyleManager.getIndent(((Object)chars.subSequence(spaceStart, spaceEnd)).toString(), fileType);
        int newEnd = codeStyleManager.adjustLineIndent(document, spaceEnd);
        chars = document.getCharsSequence();
        if (spaceStart > newEnd) {
            newEnd = spaceStart;
        }
        Indent newIndent = codeStyleManager.getIndent(((Object)chars.subSequence(spaceStart, newEnd)).toString(), fileType);
        Indent indentShift = newIndent.subtract(indent);
        ArrayList<Boolean> indentFlags = new ArrayList<Boolean>();
        if (!indentShift.isZero()) {
            int offset1;
            int offset12;
            endOffset += newEnd - spaceEnd;
            int offset = newEnd;
            while ((offset = CharArrayUtil.shiftForwardUntil((CharSequence)chars, (int)offset, (String)"\n\r")) < endOffset && (offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)"\n\r")) < endOffset && (offset12 = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t")) < endOffset) {
                if (chars.charAt(offset12) == '\n' || chars.charAt(offset12) == '\r') {
                    offset = offset12;
                    continue;
                }
                Boolean flag = codeStyleManager.isLineToBeIndented(file, offset) ? Boolean.TRUE : Boolean.FALSE;
                indentFlags.add(flag);
                offset = offset12;
            }
            offset = newEnd;
            int count = 0;
            while ((offset = CharArrayUtil.shiftForwardUntil((CharSequence)chars, (int)offset, (String)"\n\r")) < endOffset && (offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)"\n\r")) < endOffset && (offset1 = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t")) < endOffset) {
                int index;
                if (chars.charAt(offset1) == '\n' || chars.charAt(offset1) == '\r') {
                    offset = offset1;
                    continue;
                }
                if (indentFlags.get(index = count++) == Boolean.FALSE) {
                    offset = offset1;
                    continue;
                }
                String space = ((Object)chars.subSequence(offset, offset1)).toString();
                indent = codeStyleManager.getIndent(space, fileType);
                indent = indent.add(indentShift);
                String newSpace = codeStyleManager.fillIndent(indent, fileType);
                document.replaceString(offset, offset1, (CharSequence)newSpace);
                chars = document.getCharsSequence();
                offset += newSpace.length();
                endOffset += newSpace.length() - space.length();
            }
        }
    }
}

