/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

class FoldingUtil {
    private FoldingUtil() {
    }

    @Nullable
    public static FoldRegion findFoldRegion(Editor editor, int startOffset, int endOffset) {
        FoldRegion[] foldRegions;
        for (FoldRegion region : foldRegions = ((FoldingModelEx)editor.getFoldingModel()).getAllFoldRegionsIncludingInvalid()) {
            if (!region.isValid() || region.getStartOffset() != startOffset || region.getEndOffset() != endOffset) continue;
            return region;
        }
        return null;
    }

    public static FoldRegion findFoldRegionStartingAtLine(Editor editor, int line) {
        FoldRegion[] regions = editor.getFoldingModel().getAllFoldRegions();
        FoldRegion result = null;
        for (FoldRegion region : regions) {
            if (region.getDocument().getLineNumber(region.getStartOffset()) != line) continue;
            if (result != null) {
                return null;
            }
            result = region;
        }
        return result;
    }

    public static FoldRegion[] getFoldRegionsAtOffset(Editor editor, int offset) {
        FoldRegion[] allRegions;
        ArrayList<FoldRegion> list = new ArrayList<FoldRegion>();
        for (FoldRegion region : allRegions = editor.getFoldingModel().getAllFoldRegions()) {
            if (region.getStartOffset() > offset || offset > region.getEndOffset()) continue;
            list.add(region);
        }
        FoldRegion[] regions = list.toArray(new FoldRegion[list.size()]);
        Arrays.sort(regions, Collections.reverseOrder(RangeMarker.BY_START_OFFSET));
        return regions;
    }

    public static boolean caretInsideRange(Editor editor, TextRange range) {
        int offset = editor.getCaretModel().getOffset();
        return range.contains(offset) && range.getStartOffset() != offset;
    }
}

