/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.StringTokenizer;

public class XmlElementSignatureProvider
extends ElementSignatureProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.XmlElementSignatureProvider");

    @Override
    public String getSignature(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            PsiElement parent = tag.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("tag#");
            String name = tag.getName();
            buffer.append(name.length() == 0 ? "<unnamed>" : name);
            buffer.append("#");
            buffer.append(XmlElementSignatureProvider.getChildIndex(tag, parent, name, XmlTag.class));
            if (parent instanceof XmlTag) {
                String parentSignature = this.getSignature(parent);
                buffer.append(";");
                buffer.append(parentSignature);
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    protected PsiElement restoreBySignatureTokens(PsiFile file, PsiElement parent, String type, StringTokenizer tokenizer) {
        if (type.equals("tag")) {
            String name = tokenizer.nextToken();
            if (parent instanceof XmlFile) {
                parent = ((XmlFile)parent).getDocument();
            }
            try {
                int index = Integer.parseInt(tokenizer.nextToken());
                XmlTag result = XmlElementSignatureProvider.restoreElementInternal(parent, name, index, XmlTag.class);
                if (result == null && file.getFileType() == StdFileTypes.JSP) {
                    if (parent instanceof XmlDocument) {
                        result = XmlElementSignatureProvider.restoreElementInternal((PsiElement)HtmlUtil.getRealXmlDocument((XmlDocument)parent), name, index, XmlTag.class);
                    } else if (name.equals("<unnamed>") && parent != null) {
                        result = XmlElementSignatureProvider.restoreElementInternal(parent, "", index, XmlTag.class);
                    }
                }
                return result;
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return null;
    }
}

