/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;

public class FileLevelIntentionComponent
extends EditorNotificationPanel {
    private static final Icon ourIntentionIcon = IconLoader.getIcon((String)"/actions/intentionBulb.png");
    private static final Icon ourQuickFixIcon = IconLoader.getIcon((String)"/actions/quickfixBulb.png");
    private final Project myProject;

    public FileLevelIntentionComponent(String description, HighlightSeverity severity, final List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> intentions, final Project project, final PsiFile psiFile, final Editor editor) {
        this.myProject = project;
        final ShowIntentionsPass.IntentionsInfo info = new ShowIntentionsPass.IntentionsInfo();
        if (intentions != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> intention : intentions) {
                final HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)intention.getFirst();
                info.intentionsToShow.add(descriptor);
                this.createActionLabel(descriptor.getAction().getText(), new Runnable(){

                    @Override
                    public void run() {
                        descriptor.getAction().invoke(project, editor, psiFile);
                    }
                });
            }
        }
        this.myLabel.setText(description);
        this.myLabel.setIcon(SeverityRegistrar.getInstance(project).compare(severity, HighlightSeverity.ERROR) >= 0 ? ourQuickFixIcon : ourIntentionIcon);
        this.setBackground(this.getColor(severity));
        this.myLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IntentionListStep step = new IntentionListStep(null, info, editor, psiFile, project);
                if (intentions != null && !intentions.isEmpty()) {
                    HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)((Pair)intentions.get(0)).getFirst();
                    IntentionActionWithTextCaching actionWithTextCaching = step.wrapAction((PsiElement)psiFile, descriptor);
                    step = step.getSubStep(actionWithTextCaching, null);
                }
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showUnderneathOf((Component)FileLevelIntentionComponent.this.myLabel);
            }
        });
    }

    private Color getColor(HighlightSeverity severity) {
        if (SeverityRegistrar.getInstance(this.myProject).compare(severity, HighlightSeverity.ERROR) >= 0) {
            return LightColors.RED;
        }
        if (SeverityRegistrar.getInstance(this.myProject).compare(severity, HighlightSeverity.WARNING) >= 0) {
            return LightColors.YELLOW;
        }
        return Color.white;
    }
}

