/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData");
    @NotNull
    private final IntentionAction myAction;
    private final ClassLoader myIntentionLoader;
    private final String myDescriptionDirectoryName;
    @NotNull
    public final String[] myCategory;
    private TextDescriptor[] myExampleUsagesBefore;
    private TextDescriptor[] myExampleUsagesAfter;
    private TextDescriptor myDescription;
    private URL myDirURL;
    @NonNls
    private static final String BEFORE_TEMPLATE_PREFIX = "before";
    @NonNls
    private static final String AFTER_TEMPLATE_PREFIX = "after";
    @NonNls
    static final String EXAMPLE_USAGE_URL_SUFFIX = ".template";
    @NonNls
    private static final String DESCRIPTION_FILE_NAME = "description.html";
    @NonNls
    private static final String INTENTION_DESCRIPTION_FOLDER = "intentionDescriptions";

    public IntentionActionMetaData(@NotNull IntentionAction action, @Nullable ClassLoader loader, @NotNull String[] category, @NotNull String descriptionDirectoryName) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.<init> must not be null");
        }
        if (category == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.<init> must not be null");
        }
        if (descriptionDirectoryName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.<init> must not be null");
        }
        this.myExampleUsagesBefore = null;
        this.myExampleUsagesAfter = null;
        this.myDescription = null;
        this.myDirURL = null;
        this.myAction = action;
        this.myIntentionLoader = loader;
        this.myCategory = category;
        this.myDescriptionDirectoryName = descriptionDirectoryName;
    }

    public IntentionActionMetaData(@NotNull IntentionAction action, @NotNull String[] category, TextDescriptor description, TextDescriptor[] exampleUsagesBefore, TextDescriptor[] exampleUsagesAfter) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.<init> must not be null");
        }
        if (category == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.<init> must not be null");
        }
        this.myExampleUsagesBefore = null;
        this.myExampleUsagesAfter = null;
        this.myDescription = null;
        this.myDirURL = null;
        this.myAction = action;
        this.myCategory = category;
        this.myExampleUsagesBefore = exampleUsagesBefore;
        this.myExampleUsagesAfter = exampleUsagesAfter;
        this.myDescription = description;
        this.myIntentionLoader = null;
        this.myDescriptionDirectoryName = null;
    }

    public String toString() {
        return this.getFamily();
    }

    @NotNull
    public TextDescriptor[] getExampleUsagesBefore() {
        if (this.myExampleUsagesBefore == null) {
            try {
                this.myExampleUsagesBefore = IntentionActionMetaData.retrieveURLs(this.getDirURL(), BEFORE_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myExampleUsagesBefore == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.getExampleUsagesBefore must not return null");
        }
        return this.myExampleUsagesBefore;
    }

    @NotNull
    public TextDescriptor[] getExampleUsagesAfter() {
        if (this.myExampleUsagesAfter == null) {
            try {
                this.myExampleUsagesAfter = IntentionActionMetaData.retrieveURLs(this.getDirURL(), AFTER_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myExampleUsagesAfter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.getExampleUsagesAfter must not return null");
        }
        return this.myExampleUsagesAfter;
    }

    @NotNull
    public TextDescriptor getDescription() {
        if (this.myDescription == null) {
            try {
                URL dirURL = this.getDirURL();
                URL descriptionURL = new URL(dirURL.toExternalForm() + "/" + DESCRIPTION_FILE_NAME);
                this.myDescription = new ResourceTextDescriptor(descriptionURL);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        TextDescriptor textDescriptor = this.myDescription;
        if (textDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.getDescription must not return null");
        }
        return textDescriptor;
    }

    private static TextDescriptor[] retrieveURLs(@NotNull URL descriptionDirectory, @NotNull String prefix, @NotNull String suffix) throws MalformedURLException {
        FileType[] fileTypes;
        if (descriptionDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.retrieveURLs must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.retrieveURLs must not be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.retrieveURLs must not be null");
        }
        ArrayList<ResourceTextDescriptor> urls = new ArrayList<ResourceTextDescriptor>();
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            String[] extensions;
            block3: for (String extension : extensions = FileTypeManager.getInstance().getAssociatedExtensions(fileType)) {
                int i = 0;
                while (true) {
                    URL url = new URL(descriptionDirectory.toExternalForm() + "/" + prefix + "." + extension + (i == 0 ? "" : Integer.toString(i)) + suffix);
                    try {
                        InputStream inputStream = url.openStream();
                        inputStream.close();
                        urls.add(new ResourceTextDescriptor(url));
                    }
                    catch (IOException ioe) {
                        continue block3;
                    }
                    ++i;
                }
            }
        }
        return urls.isEmpty() ? null : urls.toArray(new TextDescriptor[urls.size()]);
    }

    private static URL getIntentionDescriptionDirURL(ClassLoader aClassLoader, String intentionFolderName) {
        URL pageURL = aClassLoader.getResource("intentionDescriptions/" + intentionFolderName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path:intentionDescriptions/" + intentionFolderName);
            LOG.debug("URL:" + pageURL);
        }
        return pageURL;
    }

    private URL getDirURL() {
        if (this.myDirURL == null) {
            this.myDirURL = IntentionActionMetaData.getIntentionDescriptionDirURL(this.myIntentionLoader, this.myDescriptionDirectoryName);
        }
        if (this.myDirURL == null) {
            this.myDirURL = IntentionActionMetaData.getIntentionDescriptionDirURL(this.myIntentionLoader, this.getFamily());
        }
        LOG.assertTrue(this.myDirURL != null, (Object)("Intention Description Dir URL is null: " + this.getFamily() + "; " + this.myDescriptionDirectoryName + ", " + this.myIntentionLoader));
        return this.myDirURL;
    }

    @Nullable
    public PluginId getPluginId() {
        if (this.myIntentionLoader instanceof PluginClassLoader) {
            return ((PluginClassLoader)this.myIntentionLoader).getPluginId();
        }
        return null;
    }

    @NotNull
    public String getFamily() {
        String string = this.myAction.getFamilyName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.getFamily must not return null");
        }
        return string;
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData.getAction must not return null");
        }
        return intentionAction;
    }
}

