/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import javax.swing.JList;

public final class NavigationUtil {
    private NavigationUtil() {
    }

    public static JBPopup getPsiElementPopup(PsiElement[] elements, String title) {
        return NavigationUtil.getPsiElementPopup(elements, new DefaultPsiElementCellRenderer(), title);
    }

    public static JBPopup getPsiElementPopup(PsiElement[] elements, PsiElementListCellRenderer renderer, String title) {
        return NavigationUtil.getPsiElementPopup((PsiElement[])elements, (PsiElementListCellRenderer)renderer, (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

            public boolean execute(PsiElement element) {
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)element);
                if (descriptor != null && descriptor.canNavigate()) {
                    descriptor.navigate(true);
                }
                return true;
            }
        });
    }

    public static <T extends PsiElement> JBPopup getPsiElementPopup(T[] elements, PsiElementListCellRenderer<T> renderer, String title, final PsiElementProcessor<T> processor) {
        final JList<T> list = new JList<T>(elements);
        list.setCellRenderer(renderer);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int[] ids = list.getSelectedIndices();
                if (ids == null || ids.length == 0) {
                    return;
                }
                for (Object element : list.getSelectedValues()) {
                    if (element == null) continue;
                    processor.execute((PsiElement)element);
                }
            }
        };
        PopupChooserBuilder builder = new PopupChooserBuilder(list);
        if (title != null) {
            builder.setTitle(title);
        }
        renderer.installSpeedSearch(builder);
        return builder.setItemChoosenCallback(runnable).createPopup();
    }

    public static void activateFileWithPsiElement(PsiElement elt) {
        if (!NavigationUtil.activatePsiElementIfOpen(elt)) {
            ((NavigationItem)elt).navigate(true);
        }
    }

    private static boolean activatePsiElementIfOpen(PsiElement elt) {
        FileEditor[] editors;
        if (!elt.isValid()) {
            return false;
        }
        PsiFile file = elt.getContainingFile();
        if (file == null || !file.isValid()) {
            return false;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        FileEditorManager fem = FileEditorManager.getInstance((Project)elt.getProject());
        if (!fem.isFileOpen(vFile)) {
            return false;
        }
        TextRange range = elt.getTextRange();
        if (range == null) {
            return false;
        }
        for (FileEditor editor : editors = fem.getEditors(vFile)) {
            Editor text;
            int offset;
            if (!(editor instanceof TextEditor) || !range.contains(offset = (text = ((TextEditor)editor).getEditor()).getCaretModel().getOffset())) continue;
            fem.openFile(vFile, true);
            return true;
        }
        return false;
    }
}

