/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.ImageOrColorPreviewManager;
import com.intellij.codeInsight.preview.PreviewHintProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ImageOrColorPreviewProjectComponent
extends AbstractProjectComponent {
    public ImageOrColorPreviewProjectComponent(Project project) {
        super(project);
    }

    public void projectOpened() {
        FileEditorManager.getInstance((Project)this.myProject).addFileEditorManagerListener((FileEditorManagerListener)new MyFileEditorManagerListener(), (Disposable)this.myProject);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ImageOrColorPreviewComponent" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/preview/ImageOrColorPreviewProjectComponent.getComponentName must not return null");
        }
        return "ImageOrColorPreviewComponent";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(FileEditorManager source, VirtualFile file) {
            if (MyFileEditorManagerListener.isSuitable(source.getProject(), file)) {
                FileEditor[] fileEditors;
                for (FileEditor each : fileEditors = source.getEditors(file)) {
                    if (!(each instanceof TextEditor)) continue;
                    Disposer.register((Disposable)each, (Disposable)new ImageOrColorPreviewManager((TextEditor)each));
                }
            }
        }

        private static boolean isSuitable(Project project, VirtualFile file) {
            FileViewProvider provider = PsiManager.getInstance((Project)project).findViewProvider(file);
            if (provider == null) {
                return false;
            }
            for (PsiFile psiFile : provider.getAllFiles()) {
                for (PreviewHintProvider hintProvider : (PreviewHintProvider[])Extensions.getExtensions((ExtensionPointName)PreviewHintProvider.EP_NAME)) {
                    if (!hintProvider.isSupportedFile(psiFile)) continue;
                    return true;
                }
            }
            return false;
        }

        public void fileClosed(FileEditorManager source, VirtualFile file) {
        }

        public void selectionChanged(FileEditorManagerEvent event) {
        }
    }
}

