/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;

public abstract class JavaElseUnwrapperBase
extends JavaUnwrapper {
    public JavaElseUnwrapperBase(String description) {
        super(description);
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        return (this.isElseBlock(e) || this.isElseKeyword(e)) && this.isValidConstruct(e);
    }

    private boolean isElseKeyword(PsiElement e) {
        PsiElement p = e.getParent();
        return p instanceof PsiIfStatement && e == ((PsiIfStatement)p).getElseElement();
    }

    private boolean isValidConstruct(PsiElement e) {
        return ((PsiIfStatement)e.getParent()).getElseBranch() != null;
    }

    @Override
    public void collectElementsToIgnore(PsiElement element, Set<PsiElement> result) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiIfStatement) {
            result.add(parent);
            parent = parent.getParent();
        }
    }

    @Override
    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiStatement elseBranch = this.isElseKeyword(element) ? ((PsiIfStatement)element.getParent()).getElseBranch() : (PsiStatement)element;
        this.unwrapElseBranch(elseBranch, element.getParent(), context);
    }

    protected abstract void unwrapElseBranch(PsiStatement var1, PsiElement var2, JavaUnwrapper.Context var3) throws IncorrectOperationException;
}

