/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SurroundWithIfFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.SurroundWithIfFix");
    private final PsiExpression myExpression;
    private final String myText;

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SurroundWithIfFix.getName must not return null");
        }
        return string;
    }

    public SurroundWithIfFix(@NotNull PsiExpression expressionToAssert) {
        if (expressionToAssert == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/SurroundWithIfFix.<init> must not be null");
        }
        this.myExpression = expressionToAssert;
        this.myText = this.myExpression.getText();
    }

    private static Editor getEditor(Project project, PsiElement element) {
        FileEditor[] editors;
        for (FileEditor fileEditor : editors = FileEditorManager.getInstance((Project)project).getEditors(element.getContainingFile().getVirtualFile())) {
            if (!(fileEditor instanceof TextEditor)) continue;
            return ((TextEditor)fileEditor).getEditor();
        }
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/SurroundWithIfFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/SurroundWithIfFix.applyFix must not be null");
        }
        PsiElement element = descriptor.getPsiElement();
        PsiStatement anchorStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        LOG.assertTrue(anchorStatement != null);
        Editor editor = SurroundWithIfFix.getEditor(project, element);
        if (editor == null) {
            return;
        }
        PsiFile file = element.getContainingFile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{anchorStatement};
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchorStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev instanceof PsiComment && SuppressManager.getInstance().getSuppressedInspectionIdsIn(prev) != null) {
            elements = new PsiElement[]{prev, anchorStatement};
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project, editor, elements);
            if (textRange == null) {
                return;
            }
            String newText = this.myText + " != null";
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
            editor.getCaretModel().moveToOffset(textRange.getEndOffset() + newText.length());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SurroundWithIfFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable() {
        if (!this.myExpression.isValid() || this.myText == null) {
            return false;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myExpression, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        PsiElement parent = statement.getParent();
        return !(parent instanceof PsiForStatement);
    }
}

