/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiVariable;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DfaVariableState
implements Cloneable {
    private final Set<DfaTypeValue> myInstanceofValues;
    private final Set<DfaTypeValue> myNotInstanceofValues;
    private boolean myNullable = false;
    private final boolean myVariableIsDeclaredNotNull;
    private final PsiVariable myVar;

    public DfaVariableState(@Nullable PsiVariable var) {
        this.myVar = var;
        this.myInstanceofValues = new HashSet<DfaTypeValue>();
        this.myNotInstanceofValues = new HashSet<DfaTypeValue>();
        this.myNullable = var != null && AnnotationUtil.isNullable((PsiModifierListOwner)var);
        this.myVariableIsDeclaredNotNull = var != null && AnnotationUtil.isNotNull((PsiModifierListOwner)var);
    }

    protected DfaVariableState(DfaVariableState toClone) {
        this.myVar = toClone.myVar;
        this.myInstanceofValues = new THashSet(toClone.myInstanceofValues);
        this.myNotInstanceofValues = new THashSet(toClone.myNotInstanceofValues);
        this.myNullable = toClone.myNullable;
        this.myVariableIsDeclaredNotNull = toClone.myVariableIsDeclaredNotNull;
    }

    public boolean isNullable() {
        return this.myNullable;
    }

    private boolean checkInstanceofValue(DfaTypeValue dfaType) {
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaTypeValue dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaTypeValue dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    public boolean setInstanceofValue(DfaTypeValue dfaType) {
        this.myNullable |= dfaType.isNullable();
        if (dfaType.getType() instanceof PsiPrimitiveType) {
            return true;
        }
        if (this.checkInstanceofValue(dfaType)) {
            this.myInstanceofValues.add(dfaType);
            return true;
        }
        return false;
    }

    public boolean addNotInstanceofValue(DfaTypeValue dfaType) {
        if (this.myNotInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaTypeValue dfaTypeValue : this.myInstanceofValues) {
            if (!dfaType.isAssignableFrom(dfaTypeValue)) continue;
            return false;
        }
        this.myNotInstanceofValues.add(dfaType);
        return true;
    }

    public int hashCode() {
        return ((Object)this.myInstanceofValues).hashCode() + ((Object)this.myNotInstanceofValues).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return ((Object)this.myInstanceofValues).equals(aState.myInstanceofValues) && ((Object)this.myNotInstanceofValues).equals(aState.myNotInstanceofValues) && this.myNullable == aState.myNullable;
    }

    protected Object clone() throws CloneNotSupportedException {
        return new DfaVariableState(this);
    }

    public String toString() {
        DfaTypeValue dfaTypeValue;
        StringBuilder buf = new StringBuilder();
        buf.append("instanceof {");
        Iterator<DfaTypeValue> iterator = this.myInstanceofValues.iterator();
        while (iterator.hasNext()) {
            dfaTypeValue = iterator.next();
            buf.append(dfaTypeValue);
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("} ");
        buf.append("not instanceof {");
        iterator = this.myNotInstanceofValues.iterator();
        while (iterator.hasNext()) {
            dfaTypeValue = iterator.next();
            buf.append(dfaTypeValue);
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("}");
        buf.append(", nullable=").append(this.myNullable);
        return buf.toString();
    }

    public boolean isNotNull() {
        return this.myVariableIsDeclaredNotNull;
    }

    public void setNullable(boolean nullable) {
        this.myNullable = nullable;
    }

    public PsiVariable getVariable() {
        return this.myVar;
    }

    public void setValue(DfaValue value) {
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }
}

