/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.util.IconUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefJavaElementImpl
extends RefElementImpl
implements RefJavaElement {
    private Set<RefClass> myOutTypeReferences;
    private static final int ACCESS_MODIFIER_MASK = 3;
    private static final int ACCESS_PRIVATE = 0;
    private static final int ACCESS_PROTECTED = 1;
    private static final int ACCESS_PACKAGE = 2;
    private static final int ACCESS_PUBLIC = 3;
    private static final int IS_STATIC_MASK = 4;
    private static final int IS_FINAL_MASK = 8;
    private static final int IS_USES_DEPRECATION_MASK = 512;
    private static final int IS_SYNTHETIC_JSP_ELEMENT = 1024;

    protected RefJavaElementImpl(String name, RefJavaElement owner) {
        super(name, (RefElement)owner);
        String am = owner.getAccessModifier();
        this.doSetAccessModifier(am);
        boolean synthOwner = owner.isSyntheticJSP();
        if (synthOwner) {
            this.setSyntheticJSP(true);
        }
    }

    protected RefJavaElementImpl(PsiFile file, RefManager manager) {
        super(file, manager);
    }

    protected RefJavaElementImpl(PsiModifierListOwner elem, RefManager manager) {
        super(RefJavaElementImpl.getName((PsiElement)elem), (PsiElement)elem, manager);
        boolean isSynth;
        this.setAccessModifier(RefJavaUtil.getInstance().getAccessModifier(elem));
        boolean bl = isSynth = elem instanceof JspHolderMethod || elem instanceof JspClass;
        if (isSynth) {
            this.setSyntheticJSP(true);
        }
        this.setIsStatic(elem.hasModifierProperty("static"));
        this.setIsFinal(elem.hasModifierProperty("final"));
    }

    @Override
    protected SmartPsiElementPointer<PsiElement> createPointer(PsiElement element, RefManager manager) {
        if (element instanceof JspHolderMethod || element instanceof JspClass) {
            return SmartPointerManager.getInstance((Project)manager.getProject()).createSmartPsiElementPointer(element);
        }
        return super.createPointer(element, manager);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<RefClass> getOutTypeReferences() {
        Set<Object> set;
        if (this.myOutTypeReferences == null) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefJavaElementImpl.getOutTypeReferences must not return null");
            return set;
        }
        set = this.myOutTypeReferences;
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/reference/RefJavaElementImpl.getOutTypeReferences must not return null");
    }

    public void addOutTypeRefernce(RefClass refClass) {
        if (this.myOutTypeReferences == null) {
            this.myOutTypeReferences = new THashSet();
        }
        this.myOutTypeReferences.add(refClass);
    }

    public static String getName(PsiElement element) {
        if (element instanceof PsiAnonymousClass) {
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)element;
            PsiClass psiBaseClass = psiAnonymousClass.getBaseClassType().resolve();
            return InspectionsBundle.message((String)"inspection.reference.anonymous.name", (Object[])new Object[]{psiBaseClass == null ? "" : psiBaseClass.getQualifiedName()});
        }
        if (element instanceof JspClass) {
            JspClass jspClass = (JspClass)element;
            PsiFile jspxFile = jspClass.getContainingFile();
            return "<" + jspxFile.getName() + ">";
        }
        if (element instanceof JspHolderMethod) {
            return InspectionsBundle.message((String)"inspection.reference.jsp.holder.method.anonymous.name", (Object[])new Object[0]);
        }
        String name = null;
        if (element instanceof PsiNamedElement) {
            name = ((PsiNamedElement)element).getName();
        }
        return name == null ? InspectionsBundle.message((String)"inspection.reference.anonymous", (Object[])new Object[0]) : name;
    }

    public boolean isFinal() {
        return this.checkFlag(8);
    }

    public boolean isStatic() {
        return this.checkFlag(4);
    }

    public void setIsStatic(boolean isStatic) {
        this.setFlag(isStatic, 4);
    }

    public boolean isUsesDeprecatedApi() {
        return this.checkFlag(512);
    }

    public void setUsesDeprecatedApi(boolean usesDeprecatedApi) {
        this.setFlag(usesDeprecatedApi, 512);
    }

    public void setIsFinal(boolean isFinal) {
        this.setFlag(isFinal, 8);
    }

    public void setReachable(boolean reachable) {
        this.setFlag(reachable, 64);
    }

    public boolean isSyntheticJSP() {
        return this.checkFlag(1024);
    }

    public void setSyntheticJSP(boolean b) {
        this.setFlag(b, 1024);
    }

    @Modifier
    @Nullable
    public String getAccessModifier() {
        long access_id = this.myFlags & 3;
        if (access_id == 0L) {
            return "private";
        }
        if (access_id == 3L) {
            return "public";
        }
        if (access_id == 2L) {
            return "packageLocal";
        }
        return "protected";
    }

    public void setAccessModifier(String am) {
        this.doSetAccessModifier(am);
    }

    private void doSetAccessModifier(String am) {
        int access_id = "private".equals(am) ? 0 : ("public".equals(am) ? 3 : ("packageLocal".equals(am) ? 2 : 1));
        this.myFlags = this.myFlags & 0xFFFFFFFC | access_id;
    }

    public boolean isSuspiciousRecursive() {
        return this.isCalledOnlyFrom(this, new Stack<RefJavaElement>());
    }

    private boolean isCalledOnlyFrom(RefJavaElement refElement, Stack<RefJavaElement> callStack) {
        if (callStack.contains(this)) {
            return refElement == this;
        }
        if (this.getInReferences().isEmpty()) {
            return false;
        }
        if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                if (refSuper.getInReferences().isEmpty()) continue;
                return false;
            }
            if (refMethod.isConstructor()) {
                boolean unreachable = true;
                for (RefElement refOut : refMethod.getOutReferences()) {
                    unreachable &= !refOut.isReachable();
                }
                if (unreachable) {
                    return true;
                }
            }
        }
        callStack.push(this);
        for (RefElement refCaller : this.getInReferences()) {
            if (((RefElementImpl)refCaller).isSuspicious() && ((RefJavaElementImpl)refCaller).isCalledOnlyFrom(refElement, callStack)) continue;
            callStack.pop();
            return false;
        }
        callStack.pop();
        return true;
    }

    public void addReference(RefElement refWhat, PsiElement psiWhat, PsiElement psiFrom, boolean forWriting, boolean forReading, PsiReferenceExpression expression) {
        if (refWhat != null) {
            if (refWhat instanceof RefParameter) {
                if (forWriting) {
                    ((RefParameter)refWhat).parameterReferenced(true);
                }
                if (forReading) {
                    ((RefParameter)refWhat).parameterReferenced(false);
                }
            }
            this.addOutReference(refWhat);
            ((RefJavaElementImpl)refWhat).markReferenced(this, psiFrom, psiWhat, forWriting, forReading, expression);
        }
    }

    protected void markReferenced(RefElementImpl refFrom, PsiElement psiFrom, PsiElement psiWhat, boolean forWriting, boolean forReading, PsiReferenceExpression expressionFrom) {
        this.addInReference(refFrom);
        this.getRefManager().fireNodeMarkedReferenced(this, refFrom, false, forReading, forWriting);
    }

    protected RefJavaManager getRefJavaManager() {
        return (RefJavaManager)this.getRefManager().getExtension(RefJavaManager.MANAGER);
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        if (this.isEntry()) {
            this.getRefJavaManager().getEntryPointsManager().removeEntryPoint((RefElement)this);
        }
    }

    @Override
    public Icon getIcon(boolean expanded) {
        PsiElement element;
        if (this.isSyntheticJSP() && (element = this.getElement()) != null && element.isValid()) {
            return IconUtil.getIcon((VirtualFile)element.getContainingFile().getVirtualFile(), (int)3, (Project)element.getProject());
        }
        return super.getIcon(expanded);
    }
}

