/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.Browser;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.codeInspection.ui.actions.InspectionsOptionsToolbarAction;
import com.intellij.codeInspection.ui.actions.InvokeQuickFixAction;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TreeExpander;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionResultsView
extends JPanel
implements Disposable,
OccurenceNavigator,
DataProvider {
    public static final DataKey<InspectionResultsView> DATA_KEY = DataKey.create((String)"inspectionView");
    private final Project myProject;
    private InspectionTree myTree;
    private final Browser myBrowser;
    private Map<HighlightDisplayLevel, Map<String, InspectionGroupNode>> myGroups = null;
    private OccurenceNavigator myOccurenceNavigator;
    private InspectionProfile myInspectionProfile;
    private final AnalysisScope myScope;
    @NonNls
    private static final String HELP_ID = "reference.toolWindows.inspections";
    private final Map<HighlightDisplayLevel, InspectionSeverityGroupNode> mySeverityGroupNodes = new HashMap<HighlightDisplayLevel, InspectionSeverityGroupNode>();
    private final Splitter mySplitter;
    private final GlobalInspectionContextImpl myGlobalInspectionContext;
    private boolean myRerun = false;
    private final InspectionRVContentProvider myProvider;
    private AnAction myIncludeAction;
    private AnAction myExcludeAction;

    public InspectionResultsView(final Project project, InspectionProfile inspectionProfile, AnalysisScope scope, GlobalInspectionContextImpl globalInspectionContext, InspectionRVContentProvider provider) {
        this.setLayout(new BorderLayout());
        this.myProject = project;
        this.myInspectionProfile = inspectionProfile;
        this.myScope = scope;
        this.myGlobalInspectionContext = globalInspectionContext;
        this.myProvider = provider;
        this.myTree = new InspectionTree(project);
        this.initTreeListeners();
        this.myOccurenceNavigator = this.initOccurenceNavigator();
        this.myBrowser = new Browser(this);
        this.mySplitter = new Splitter(false, AnalysisUIOptions.getInstance((Project)this.myProject).SPLITTER_PROPORTION);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myTree)));
        this.mySplitter.setSecondComponent((JComponent)this.myBrowser);
        this.mySplitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("proportion".equals(evt.getPropertyName())) {
                    InspectionResultsView.this.myGlobalInspectionContext.setSplitterProportion(((Float)evt.getNewValue()).floatValue());
                }
            }
        });
        this.add((Component)this.mySplitter, "Center");
        this.myBrowser.addClickListener(new Browser.ClickListener(){

            @Override
            public void referenceClicked(Browser.ClickEvent e) {
                if (e.getEventType() == 1) {
                    RefElement refElement = e.getClickedElement();
                    OpenFileDescriptor descriptor = InspectionResultsView.getOpenFileDescriptor(refElement);
                    if (descriptor != null) {
                        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, false);
                    }
                } else if (e.getEventType() == 2) {
                    VirtualFile file = e.getFile();
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, e.getStartOffset());
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                    if (editor != null) {
                        TextAttributes selectionAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, e.getStartOffset(), e.getEndOffset(), selectionAttributes, true, null);
                    }
                }
            }
        });
        this.createActionsToolbar();
    }

    private void initTreeListeners() {
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InspectionResultsView.this.syncBrowser();
                if (InspectionResultsView.this.isAutoScrollMode()) {
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)InspectionResultsView.this), (boolean)false);
                }
            }
        });
        this.myTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getClickCount() == 2) {
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)InspectionResultsView.this), (boolean)true);
                }
            }
        });
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)InspectionResultsView.this), (boolean)false);
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                InspectionResultsView.this.popupInvoked(comp, x, y);
            }
        });
        SmartExpander.installOn((JTree)((Object)this.myTree));
    }

    private OccurenceNavigatorSupport initOccurenceNavigator() {
        return new OccurenceNavigatorSupport((JTree)((Object)this.myTree)){

            @Nullable
            protected Navigatable createDescriptorForNode(DefaultMutableTreeNode node) {
                if (node instanceof RefElementNode) {
                    RefElementNode refNode = (RefElementNode)node;
                    if (refNode.hasDescriptorsUnder()) {
                        return null;
                    }
                    RefEntity element = refNode.getElement();
                    if (element == null || !element.isValid()) {
                        return null;
                    }
                    CommonProblemDescriptor problem = refNode.getProblem();
                    if (problem != null) {
                        return this.navigate(problem);
                    }
                    if (element instanceof RefElement) {
                        return InspectionResultsView.getOpenFileDescriptor((RefElement)element);
                    }
                } else if (node instanceof ProblemDescriptionNode) {
                    if (!((ProblemDescriptionNode)node).isValid()) {
                        return null;
                    }
                    return this.navigate(((ProblemDescriptionNode)node).getDescriptor());
                }
                return null;
            }

            @Nullable
            private Navigatable navigate(CommonProblemDescriptor descriptor) {
                return InspectionResultsView.this.getSelectedNavigatable(descriptor);
            }

            public String getNextOccurenceActionName() {
                return InspectionsBundle.message((String)"inspection.action.go.next", (Object[])new Object[0]);
            }

            public String getPreviousOccurenceActionName() {
                return InspectionsBundle.message((String)"inspection.actiongo.prev", (Object[])new Object[0]);
            }
        };
    }

    private void createActionsToolbar() {
        JComponent leftActionsToolbar = this.createLeftActionsToolbar();
        JComponent rightActionsToolbar = this.createRightActionsToolbar();
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)leftActionsToolbar, "West");
        westPanel.add((Component)rightActionsToolbar, "East");
        this.add((Component)westPanel, "West");
    }

    private JComponent createRightActionsToolbar() {
        this.myIncludeAction = new AnAction(InspectionsBundle.message((String)"inspections.result.view.include.action.text", (Object[])new Object[0])){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)((Object)InspectionResultsView.this.myTree));
            }

            public void actionPerformed(AnActionEvent e) {
                ((InspectionTreeNode)InspectionResultsView.this.myTree.getSelectionPath().getLastPathComponent()).amnesty();
                InspectionResultsView.this.updateView(false);
            }

            public void update(AnActionEvent e) {
                TreePath path = InspectionResultsView.this.myTree.getSelectionPath();
                e.getPresentation().setEnabled(path != null && !((InspectionResultsView)InspectionResultsView.this).myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS);
            }
        };
        this.myExcludeAction = new AnAction(InspectionsBundle.message((String)"inspections.result.view.exclude.action.text", (Object[])new Object[0])){
            {
                this.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)((Object)InspectionResultsView.this.myTree));
            }

            public void actionPerformed(AnActionEvent e) {
                ((InspectionTreeNode)InspectionResultsView.this.myTree.getSelectionPath().getLastPathComponent()).ignoreElement();
                InspectionResultsView.this.updateView(false);
            }

            public void update(AnActionEvent e) {
                TreePath path = InspectionResultsView.this.myTree.getSelectionPath();
                e.getPresentation().setEnabled(path != null);
            }
        };
        DefaultActionGroup specialGroup = new DefaultActionGroup();
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupBySeverityAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupByDirectoryAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createFilterResolvedItemsAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createShowOutdatedProblemsAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createShowDiffOnlyAction(this));
        specialGroup.add((AnAction)new EditSettingsAction());
        specialGroup.add((AnAction)new InvokeQuickFixAction(this));
        specialGroup.add((AnAction)new InspectionsOptionsToolbarAction(this));
        return InspectionResultsView.createToolbar(specialGroup);
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RerunAction(this));
        group.add((AnAction)new CloseAction());
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)((Object)InspectionResultsView.this.myTree));
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)((Object)InspectionResultsView.this.myTree), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        group.add(actionsManager.createExpandAllAction(treeExpander, (JComponent)((Object)this.myTree)));
        group.add(actionsManager.createCollapseAllAction(treeExpander, (JComponent)((Object)this.myTree)));
        group.add(actionsManager.createPrevOccurenceAction(this.getOccurenceNavigator()));
        group.add(actionsManager.createNextOccurenceAction(this.getOccurenceNavigator()));
        group.add((AnAction)this.myGlobalInspectionContext.createToggleAutoscrollAction());
        group.add((AnAction)new ExportHTMLAction(this));
        group.add((AnAction)new HelpAction());
        return InspectionResultsView.createToolbar(group);
    }

    private static JComponent createToolbar(DefaultActionGroup specialGroup) {
        return ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)specialGroup, false).getComponent();
    }

    public void dispose() {
        this.mySplitter.dispose();
        this.myBrowser.dispose();
        this.myTree = null;
        this.myOccurenceNavigator = null;
        this.myInspectionProfile = null;
    }

    private boolean isAutoScrollMode() {
        String activeToolWindowId = ToolWindowManager.getInstance((Project)this.myProject).getActiveToolWindowId();
        return this.myGlobalInspectionContext.getUIOptions().AUTOSCROLL_TO_SOURCE && (activeToolWindowId == null || activeToolWindowId.equals(ToolWindowId.INSPECTION));
    }

    @Nullable
    private static OpenFileDescriptor getOpenFileDescriptor(final RefElement refElement) {
        final VirtualFile[] file = new VirtualFile[1];
        final int[] offset = new int[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiElement psiElement = refElement.getElement();
                if (psiElement != null) {
                    PsiFile containingFile = psiElement.getContainingFile();
                    if (containingFile != null) {
                        file[0] = containingFile.getVirtualFile();
                        offset[0] = psiElement.getTextOffset();
                    }
                } else {
                    file[0] = null;
                }
            }
        });
        if (file[0] != null && file[0].isValid()) {
            return new OpenFileDescriptor(refElement.getRefManager().getProject(), file[0], offset[0]);
        }
        return null;
    }

    private void syncBrowser() {
        if (this.myTree.getSelectionModel().getSelectionCount() != 1) {
            this.myBrowser.showEmpty();
        } else {
            TreePath pathSelected = this.myTree.getSelectionModel().getLeadSelectionPath();
            if (pathSelected != null) {
                InspectionTreeNode node = (InspectionTreeNode)pathSelected.getLastPathComponent();
                if (node instanceof RefElementNode) {
                    RefElementNode refElementNode = (RefElementNode)node;
                    CommonProblemDescriptor problem = refElementNode.getProblem();
                    RefEntity refSelected = refElementNode.getElement();
                    if (problem != null) {
                        this.showInBrowser(refSelected, problem);
                    } else {
                        this.showInBrowser(refSelected);
                    }
                } else if (node instanceof ProblemDescriptionNode) {
                    ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
                    this.showInBrowser(problemNode.getElement(), problemNode.getDescriptor());
                } else if (node instanceof InspectionNode) {
                    this.showInBrowser(((InspectionNode)node).getTool());
                } else {
                    this.myBrowser.showEmpty();
                }
            }
        }
    }

    private void showInBrowser(RefEntity refEntity) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.myBrowser.showPageFor(refEntity);
        this.setCursor(currentCursor);
    }

    private void showInBrowser(InspectionTool tool) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.myBrowser.showDescription(tool);
        this.setCursor(currentCursor);
    }

    private void showInBrowser(RefEntity refEntity, CommonProblemDescriptor descriptor) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.myBrowser.showPageFor(refEntity, descriptor);
        this.setCursor(currentCursor);
    }

    private void addTool(InspectionTool tool, HighlightDisplayLevel errorLevel, boolean groupedBySeverity) {
        InspectionTreeNode parentNode = this.getToolParentNode(tool.getGroupDisplayName().length() > 0 ? tool.getGroupDisplayName() : InspectionProfileEntry.GENERAL_GROUP_NAME, errorLevel, groupedBySeverity);
        tool.createToolNode(this.myProvider, parentNode, this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE);
        this.regsisterActionShortcuts(tool);
    }

    private void regsisterActionShortcuts(InspectionTool tool) {
        QuickFixAction[] fixes = tool.getQuickFixes(null);
        if (fixes != null) {
            for (QuickFixAction fix : fixes) {
                fix.registerCustomShortcutSet(fix.getShortcutSet(), this);
            }
        }
    }

    private void clearTree() {
        this.myTree.removeAllNodes();
        this.mySeverityGroupNodes.clear();
    }

    @Nullable
    public String getCurrentProfileName() {
        return this.myInspectionProfile != null ? this.myInspectionProfile.getDisplayName() : null;
    }

    public InspectionProfile getCurrentProfile() {
        return this.myInspectionProfile;
    }

    public boolean update() {
        return this.updateView(true);
    }

    public boolean updateView(boolean strict) {
        if (!strict && !this.myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS) {
            this.myTree.repaint();
            return false;
        }
        this.clearTree();
        boolean resultsFound = this.buildTree();
        this.myTree.sort();
        this.myTree.restoreExpantionAndSelection();
        return resultsFound;
    }

    private boolean buildTree() {
        InspectionProfile profile = this.myInspectionProfile;
        boolean isGroupedBySeverity = this.myGlobalInspectionContext.getUIOptions().GROUP_BY_SEVERITY;
        this.myGroups = new HashMap<HighlightDisplayLevel, Map<String, InspectionGroupNode>>();
        Map<String, Tools> tools = this.myGlobalInspectionContext.getTools();
        boolean resultsFound = false;
        for (Tools currentTools : tools.values()) {
            InspectionTool defaultTool = (InspectionTool)currentTools.getDefaultState().getTool();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)defaultTool.getShortName());
            if (profile != null && !profile.isToolEnabled(key)) break;
            for (ScopeToolState state : currentTools.getTools()) {
                InspectionTool tool = (InspectionTool)state.getTool();
                if (!this.myProvider.checkReportedProblems(tool)) continue;
                this.addTool(tool, ((InspectionProfileImpl)profile).getErrorLevel(key, state.getScope()), isGroupedBySeverity);
                resultsFound = true;
            }
        }
        return resultsFound;
    }

    private InspectionTreeNode getToolParentNode(String groupName, HighlightDisplayLevel errorLevel, boolean groupedBySeverity) {
        InspectionGroupNode group;
        if (groupName == null || groupName.length() == 0) {
            return this.getRelativeRootNode(groupedBySeverity, errorLevel);
        }
        Map<String, InspectionGroupNode> map = this.myGroups.get(errorLevel);
        if (map == null) {
            map = new HashMap<String, InspectionGroupNode>();
            this.myGroups.put(errorLevel, map);
        }
        HashMap<String, InspectionGroupNode> searchMap = new HashMap<String, InspectionGroupNode>(map);
        if (!groupedBySeverity) {
            for (HighlightDisplayLevel level : this.myGroups.keySet()) {
                searchMap.putAll(this.myGroups.get(level));
            }
        }
        if ((group = (InspectionGroupNode)searchMap.get(groupName)) == null) {
            group = new InspectionGroupNode(groupName);
            map.put(groupName, group);
            this.getRelativeRootNode(groupedBySeverity, errorLevel).add(group);
        }
        return group;
    }

    private InspectionTreeNode getRelativeRootNode(boolean isGroupedBySeverity, HighlightDisplayLevel level) {
        if (isGroupedBySeverity) {
            if (this.mySeverityGroupNodes.containsKey(level)) {
                return this.mySeverityGroupNodes.get(level);
            }
            InspectionSeverityGroupNode severityGroupNode = new InspectionSeverityGroupNode(this.myProject, level);
            this.mySeverityGroupNodes.put(level, severityGroupNode);
            this.myTree.getRoot().add(severityGroupNode);
            return severityGroupNode;
        }
        return this.myTree.getRoot();
    }

    private OccurenceNavigator getOccurenceNavigator() {
        return this.myOccurenceNavigator;
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator != null && this.myOccurenceNavigator.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator != null && this.myOccurenceNavigator.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator != null ? this.myOccurenceNavigator.goNextOccurence() : null;
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator != null ? this.myOccurenceNavigator.goPreviousOccurence() : null;
    }

    public String getNextOccurenceActionName() {
        return this.myOccurenceNavigator != null ? this.myOccurenceNavigator.getNextOccurenceActionName() : "";
    }

    public String getPreviousOccurenceActionName() {
        return this.myOccurenceNavigator != null ? this.myOccurenceNavigator.getPreviousOccurenceActionName() : "";
    }

    public Project getProject() {
        return this.myProject;
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (this.myTree == null) {
            return null;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        if (paths.length > 1) {
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                return this.collectPsiElements();
            }
            return null;
        }
        TreePath path = paths[0];
        InspectionTreeNode selectedNode = (InspectionTreeNode)path.getLastPathComponent();
        if (selectedNode instanceof RefElementNode) {
            PsiElement psiElement;
            RefElementNode refElementNode = (RefElementNode)selectedNode;
            RefEntity refElement = refElementNode.getElement();
            if (refElement == null) {
                return null;
            }
            RefEntity item = refElement.getRefManager().getRefinedElement(refElement);
            if (item == null || !item.isValid()) {
                return null;
            }
            PsiElement psiElement2 = psiElement = item instanceof RefElement ? ((RefElement)item).getElement() : null;
            if (psiElement == null) {
                return null;
            }
            CommonProblemDescriptor problem = refElementNode.getProblem();
            if (problem != null) {
                if (problem instanceof ProblemDescriptor) {
                    psiElement = ((ProblemDescriptor)problem).getPsiElement();
                    if (psiElement == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
                return this.getSelectedNavigatable(problem, psiElement);
            }
            if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement.isValid() ? psiElement : null;
            }
        } else if (selectedNode instanceof ProblemDescriptionNode && PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getSelectedNavigatable(((ProblemDescriptionNode)selectedNode).getDescriptor());
        }
        return null;
    }

    @Nullable
    private Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor) {
        return this.getSelectedNavigatable(descriptor, descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null);
    }

    @Nullable
    private Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor, PsiElement psiElement) {
        VirtualFile virtualFile;
        Navigatable navigatable;
        if (descriptor instanceof ProblemDescriptorImpl && (navigatable = ((ProblemDescriptorImpl)descriptor).getNavigatable()) != null) {
            return navigatable;
        }
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = containingFile == null ? null : containingFile.getVirtualFile();
        if (virtualFile != null) {
            TextRange textRange;
            int startOffset = psiElement.getTextOffset();
            if (descriptor instanceof ProblemDescriptorImpl && (textRange = ((ProblemDescriptorImpl)descriptor).getTextRangeForNavigation()) != null) {
                if (virtualFile instanceof VirtualFileWindow) {
                    virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
                }
                startOffset = textRange.getStartOffset();
            }
            return new OpenFileDescriptor(this.myProject, virtualFile, startOffset);
        }
        return null;
    }

    private PsiElement[] collectPsiElements() {
        RefEntity[] refElements = this.myTree.getSelectedElements();
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            psiElements.add(psiElement);
        }
        return psiElements.toArray(new PsiElement[psiElements.size()]);
    }

    private void popupInvoked(Component component, int x, int y) {
        TreePath path = this.myTree.getLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction("EditSource"));
        actions.add(actionManager.getAction("FindUsages"));
        actions.add(this.myIncludeAction);
        actions.add(this.myExcludeAction);
        actions.addSeparator();
        InspectionTool tool = this.myTree.getSelectedTool();
        if (tool != null) {
            HighlightDisplayKey key;
            QuickFixAction[] quickFixes = this.myProvider.getQuickFixes(tool, this.myTree);
            if (quickFixes != null) {
                for (QuickFixAction quickFixe : quickFixes) {
                    actions.add((AnAction)quickFixe);
                }
            }
            if ((key = HighlightDisplayKey.find((String)tool.getShortName())) == null) {
                return;
            }
            actions.addSeparator();
            actions.add((AnAction)new EditSettingsAction());
            List<AnAction> options = new InspectionsOptionsToolbarAction(this).createActions();
            for (AnAction action : options) {
                actions.add(action);
            }
        }
        actions.addSeparator();
        actions.add(actionManager.getAction("VersionControlsGroup"));
        ActionPopupMenu menu = actionManager.createActionPopupMenu("CodeInspection", (ActionGroup)actions);
        menu.getComponent().show(component, x, y);
    }

    @NotNull
    public InspectionTree getTree() {
        InspectionTree inspectionTree = this.myTree;
        if (inspectionTree == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ui/InspectionResultsView.getTree must not return null");
        }
        return inspectionTree;
    }

    public GlobalInspectionContextImpl getGlobalInspectionContext() {
        return this.myGlobalInspectionContext;
    }

    public InspectionRVContentProvider getProvider() {
        return this.myProvider;
    }

    public boolean isSingleToolInSelection() {
        return this.myTree.getSelectedTool() != null;
    }

    public boolean isRerun() {
        boolean rerun = this.myRerun;
        this.myRerun = false;
        return rerun;
    }

    private InspectionProfile guessProfileToSelect(InspectionProjectProfileManager profileManager) {
        RefEntity[] selectedElements;
        HashSet<InspectionProfile> profiles = new HashSet<InspectionProfile>();
        for (RefEntity selectedElement : selectedElements = this.myTree.getSelectedElements()) {
            RefElement refElement;
            PsiElement element;
            if (!(selectedElement instanceof RefElement) || (element = (refElement = (RefElement)selectedElement).getElement()) == null) continue;
            profiles.add(profileManager.getInspectionProfile());
        }
        if (!profiles.isEmpty()) {
            return (InspectionProfile)profiles.iterator().next();
        }
        return (InspectionProfile)profileManager.getProjectProfileImpl();
    }

    public boolean isProfileDefined() {
        return this.myInspectionProfile != null && this.myInspectionProfile.isEditable();
    }

    public static void showPopup(AnActionEvent e, JBPopup popup) {
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            popup.showUnderneathOf(event.getComponent());
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    public AnalysisScope getScope() {
        return this.myScope;
    }

    public void updateCurrentProfile() {
        String name = this.myInspectionProfile.getName();
        this.myInspectionProfile = (InspectionProfile)this.myInspectionProfile.getProfileManager().getProfile(name);
    }

    private class RerunAction
    extends AnAction {
        public RerunAction(JComponent comp) {
            super(InspectionsBundle.message((String)"inspection.action.rerun", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.rerun", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/refreshUsages.png"));
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), comp);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(InspectionResultsView.this.myScope.isValid());
        }

        public void actionPerformed(AnActionEvent e) {
            this.rerun();
        }

        private void rerun() {
            InspectionResultsView.this.myRerun = true;
            if (InspectionResultsView.this.myScope.isValid()) {
                InspectionResultsView.this.myGlobalInspectionContext.doInspections(InspectionResultsView.this.myScope, InspectionManager.getInstance((Project)InspectionResultsView.this.myProject));
            }
        }
    }

    private static class HelpAction
    extends AnAction {
        private HelpAction() {
            super(CommonBundle.message((String)"action.help", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/help.png"));
        }

        public void actionPerformed(AnActionEvent event) {
            HelpManager.getInstance().invokeHelp(InspectionResultsView.HELP_ID);
        }
    }

    private class EditSettingsAction
    extends AnAction {
        private EditSettingsAction() {
            super(InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), IconLoader.getIcon((String)"/general/ideOptions.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            HighlightDisplayKey key;
            InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(InspectionResultsView.this.myProject);
            InspectionTool tool = InspectionResultsView.this.myTree.getSelectedTool();
            InspectionProfile inspectionProfile = InspectionResultsView.this.myInspectionProfile;
            boolean profileIsDefined = InspectionResultsView.this.isProfileDefined();
            if (!profileIsDefined) {
                inspectionProfile = InspectionResultsView.this.guessProfileToSelect(profileManager);
            }
            if (tool != null && (key = HighlightDisplayKey.find((String)tool.getShortName())) != null) {
                if (new EditInspectionToolsSettingsAction(key).editToolSettings(InspectionResultsView.this.myProject, (InspectionProfileImpl)inspectionProfile, profileIsDefined) && profileIsDefined) {
                    InspectionResultsView.this.updateCurrentProfile();
                }
                return;
            }
            if (EditInspectionToolsSettingsAction.editToolSettings(InspectionResultsView.this.myProject, inspectionProfile, profileIsDefined, null) && profileIsDefined) {
                InspectionResultsView.this.updateCurrentProfile();
            }
        }
    }

    private class CloseAction
    extends AnAction
    implements DumbAware {
        private CloseAction() {
            super(CommonBundle.message((String)"action.close", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/cancel.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            InspectionResultsView.this.myGlobalInspectionContext.close(true);
        }
    }
}

