/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.Copy;
import com.intellij.compiler.ant.taskdefs.FileSet;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import org.jetbrains.annotations.NotNull;

public class DirectoryAntCopyInstructionCreator
implements AntCopyInstructionCreator {
    private String myOutputDirectory;

    public DirectoryAntCopyInstructionCreator(String outputDirectory) {
        this.myOutputDirectory = outputDirectory;
    }

    public String getOutputDirectory() {
        return this.myOutputDirectory;
    }

    @NotNull
    public Tag createDirectoryContentCopyInstruction(@NotNull String dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator.createDirectoryContentCopyInstruction must not be null");
        }
        Copy copy = new Copy(this.myOutputDirectory);
        copy.add((Generator)new FileSet(dirPath));
        Copy copy2 = copy;
        if (copy2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator.createDirectoryContentCopyInstruction must not return null");
        }
        return copy2;
    }

    @NotNull
    public Tag createFileCopyInstruction(@NotNull String filePath, String outputFileName) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator.createFileCopyInstruction must not be null");
        }
        Copy copy = new Copy(filePath, this.myOutputDirectory + "/" + outputFileName);
        if (copy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator.createFileCopyInstruction must not return null");
        }
        return copy;
    }

    @NotNull
    public AntCopyInstructionCreator subFolder(String directoryName) {
        DirectoryAntCopyInstructionCreator directoryAntCopyInstructionCreator = new DirectoryAntCopyInstructionCreator(this.myOutputDirectory + "/" + directoryName);
        if (directoryAntCopyInstructionCreator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/ant/artifacts/DirectoryAntCopyInstructionCreator.subFolder must not return null");
        }
        return directoryAntCopyInstructionCreator;
    }

    public Generator createSubFolderCommand(String directoryName) {
        return new Mkdir(this.myOutputDirectory + "/" + directoryName);
    }
}

