/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.MemberInfoExternalizer;
import com.intellij.util.cls.ClsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class MemberInfo {
    public static final MemberInfo[] EMPTY_MEMBER_INFO_ARRAY = new MemberInfo[0];
    private static final int FLAG_INFO_UNAVAILABLE = 32768;
    private final int myName;
    private final int myDescriptor;
    private final int myGenericSignature;
    private final int myFlags;
    private final AnnotationConstantValue[] myRuntimeVisibleAnnotations;
    private final AnnotationConstantValue[] myRuntimeInvisibleAnnotations;

    protected MemberInfo(int name, int descriptor) {
        this(name, descriptor, -1, 32768, AnnotationConstantValue.EMPTY_ARRAY, AnnotationConstantValue.EMPTY_ARRAY);
    }

    protected MemberInfo(int name, int descriptor, int genericSignature, int flags, AnnotationConstantValue[] runtimeVisibleAnnotations, AnnotationConstantValue[] runtimeInvisibleAnnotations) {
        this.myDescriptor = descriptor;
        this.myGenericSignature = genericSignature;
        this.myName = name;
        this.myFlags = flags;
        this.myRuntimeVisibleAnnotations = runtimeVisibleAnnotations != null ? runtimeVisibleAnnotations : AnnotationConstantValue.EMPTY_ARRAY;
        this.myRuntimeInvisibleAnnotations = runtimeInvisibleAnnotations != null ? runtimeInvisibleAnnotations : AnnotationConstantValue.EMPTY_ARRAY;
    }

    protected MemberInfo(DataInput in) throws IOException {
        this.myName = in.readInt();
        this.myDescriptor = in.readInt();
        this.myGenericSignature = in.readInt();
        this.myFlags = in.readInt();
        this.myRuntimeVisibleAnnotations = this.loadAnnotations(in);
        this.myRuntimeInvisibleAnnotations = this.loadAnnotations(in);
    }

    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myName);
        out.writeInt(this.myDescriptor);
        out.writeInt(this.myGenericSignature);
        out.writeInt(this.myFlags);
        this.saveAnnotations(out, this.myRuntimeVisibleAnnotations);
        this.saveAnnotations(out, this.myRuntimeInvisibleAnnotations);
    }

    public int getName() {
        return this.myName;
    }

    public int getDescriptor() {
        return this.myDescriptor;
    }

    public int getGenericSignature() {
        return this.myGenericSignature;
    }

    public boolean isFlagInfoAvailable() {
        return this.myFlags != 32768;
    }

    public int getFlags() {
        return this.myFlags;
    }

    public boolean isPublic() {
        return ClsUtil.isPublic((int)this.myFlags);
    }

    public boolean isProtected() {
        return ClsUtil.isProtected((int)this.myFlags);
    }

    public boolean isFinal() {
        return ClsUtil.isFinal((int)this.myFlags);
    }

    public boolean isPrivate() {
        return ClsUtil.isPrivate((int)this.myFlags);
    }

    public boolean isPackageLocal() {
        return ClsUtil.isPackageLocal((int)this.myFlags);
    }

    public boolean isStatic() {
        return ClsUtil.isStatic((int)this.myFlags);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberInfo)) {
            return false;
        }
        MemberInfo info = (MemberInfo)obj;
        return this.myName == info.myName && this.myDescriptor == info.myDescriptor;
    }

    public int hashCode() {
        return this.myName + this.myDescriptor;
    }

    public AnnotationConstantValue[] getRuntimeVisibleAnnotations() {
        return this.myRuntimeVisibleAnnotations;
    }

    public AnnotationConstantValue[] getRuntimeInvisibleAnnotations() {
        return this.myRuntimeInvisibleAnnotations;
    }

    protected final void saveAnnotations(DataOutput out, AnnotationConstantValue[] annotations) throws IOException {
        out.writeInt(annotations.length);
        for (AnnotationConstantValue annotation : annotations) {
            MemberInfoExternalizer.saveConstantValue(out, annotation);
        }
    }

    protected final AnnotationConstantValue[] loadAnnotations(DataInput in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return AnnotationConstantValue.EMPTY_ARRAY;
        }
        AnnotationConstantValue[] annotations = new AnnotationConstantValue[size];
        for (int idx = 0; idx < size; ++idx) {
            annotations[idx] = (AnnotationConstantValue)MemberInfoExternalizer.loadConstantValue(in);
        }
        return annotations;
    }
}

