/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompilerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerUtil");

    public static String quotePath(String path) {
        if (path != null && path.indexOf(32) != -1) {
            path = path.replaceAll("\\\\", "\\\\\\\\");
            path = '\"' + path + '\"';
        }
        return path;
    }

    public static void collectFiles(Collection<File> container, File rootDir, FileFilter fileFilter) {
        File[] files = rootDir.listFiles(fileFilter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                CompilerUtil.collectFiles(container, file, fileFilter);
                continue;
            }
            container.add(file);
        }
    }

    public static Map<Module, List<VirtualFile>> buildModuleToFilesMap(CompileContext context, VirtualFile[] files) {
        return CompilerUtil.buildModuleToFilesMap(context, Arrays.asList(files));
    }

    public static Map<Module, List<VirtualFile>> buildModuleToFilesMap(final CompileContext context, final List<VirtualFile> files) {
        THashMap map = new THashMap();
        ApplicationManager.getApplication().runReadAction(new Runnable((Map)map){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            @Override
            public void run() {
                for (VirtualFile file : files) {
                    Module module = context.getModuleByFile(file);
                    if (module == null) continue;
                    ArrayList<VirtualFile> moduleFiles = (ArrayList<VirtualFile>)this.val$map.get(module);
                    if (moduleFiles == null) {
                        moduleFiles = new ArrayList<VirtualFile>();
                        this.val$map.put(module, moduleFiles);
                    }
                    moduleFiles.add(file);
                }
            }
        });
        return map;
    }

    public static void refreshIOFiles(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/CompilerUtil.refreshIOFiles must not be null");
        }
        LocalFileSystem.getInstance().refreshIoFiles(files);
    }

    public static void refreshIODirectories(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/CompilerUtil.refreshIODirectories must not be null");
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
        for (File file : files) {
            VirtualFile virtualFile = lfs.refreshAndFindFileByIoFile(file);
            if (virtualFile == null) continue;
            filesToRefresh.add(virtualFile);
        }
        RefreshQueue.getInstance().refresh(false, true, null, VfsUtil.toVirtualFileArray(filesToRefresh));
    }

    public static void refreshIOFile(File file) {
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (vFile != null) {
            vFile.refresh(false, false);
        }
    }

    public static void addLocaleOptions(List<String> commandLine, boolean launcherUsed) {
        String region;
        String country;
        commandLine.add((launcherUsed ? "-J" : "") + "-D" + "file.encoding" + "=" + CharsetToolkit.getDefaultSystemCharset().name());
        String lang = System.getProperty("user.language");
        if (lang != null) {
            commandLine.add((launcherUsed ? "-J" : "") + "-Duser.language=" + lang);
        }
        if ((country = System.getProperty("user.country")) != null) {
            commandLine.add((launcherUsed ? "-J" : "") + "-Duser.country=" + country);
        }
        if ((region = System.getProperty("user.region")) != null) {
            commandLine.add((launcherUsed ? "-J" : "") + "-Duser.region=" + region);
        }
    }

    public static void addSourceCommandLineSwitch(Sdk jdk, LanguageLevel chunkLanguageLevel, @NonNls List<String> commandLine) {
        String versionString = jdk.getVersionString();
        if (versionString == null || "".equals(versionString)) {
            throw new IllegalArgumentException(CompilerBundle.message((String)"javac.error.unknown.jdk.version", (Object[])new Object[]{jdk.getName()}));
        }
        LanguageLevel applicableLanguageLevel = CompilerUtil.getApplicableLanguageLevel(versionString, chunkLanguageLevel);
        if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_6)) {
            commandLine.add("-source");
            commandLine.add("1.6");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_5)) {
            commandLine.add("-source");
            commandLine.add("1.5");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_4)) {
            commandLine.add("-source");
            commandLine.add("1.4");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_3) && !CompilerUtil.isOfVersion(versionString, "1.3") && !CompilerUtil.isOfVersion(versionString, "1.2") && !CompilerUtil.isOfVersion(versionString, "1.1")) {
            commandLine.add("-source");
            commandLine.add("1.3");
        }
    }

    @NotNull
    public static LanguageLevel getApplicableLanguageLevel(String versionString, @NotNull LanguageLevel languageLevel) {
        boolean is5OrNewer;
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/impl/CompilerUtil.getApplicableLanguageLevel must not be null");
        }
        boolean bl = is5OrNewer = CompilerUtil.isOfVersion(versionString, "1.5") || CompilerUtil.isOfVersion(versionString, "5.0") || CompilerUtil.isOfVersion(versionString, "1.6.") || CompilerUtil.isOfVersion(versionString, "1.7.");
        if (LanguageLevel.JDK_1_5.equals((Object)languageLevel) && !is5OrNewer) {
            languageLevel = LanguageLevel.JDK_1_4;
        }
        if (LanguageLevel.JDK_1_4.equals((Object)languageLevel) && !CompilerUtil.isOfVersion(versionString, "1.4") && !is5OrNewer) {
            languageLevel = LanguageLevel.JDK_1_3;
        }
        LanguageLevel languageLevel2 = languageLevel;
        if (languageLevel2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/CompilerUtil.getApplicableLanguageLevel must not return null");
        }
        return languageLevel2;
    }

    public static boolean isOfVersion(String versionString, String checkedVersion) {
        return versionString.contains(checkedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void runInContext(CompileContext context, String title, ThrowableRunnable<T> action) throws T {
        if (title != null) {
            context.getProgressIndicator().pushState();
            context.getProgressIndicator().setText(title);
        }
        try {
            action.run();
        }
        finally {
            if (title != null) {
                context.getProgressIndicator().popState();
            }
        }
    }

    public static void logDuration(String activityName, long duration) {
        LOG.info(activityName + " took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
    }
}

