/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OutputPathFinder {
    private final Node myRoot = new Node("");

    public OutputPathFinder(Set<File> outputDirs) {
        for (File dir : outputDirs) {
            String path = FileUtil.toSystemIndependentName((String)dir.getPath());
            Node node = this.myRoot;
            int idx = path.startsWith("/") ? 1 : 0;
            int slashIndex = path.indexOf(47, idx);
            while (slashIndex >= 0) {
                String name = path.substring(idx, slashIndex);
                node = node.addChild(name);
                idx = slashIndex + 1;
                slashIndex = path.indexOf(47, idx);
            }
            if (idx < path.length()) {
                node = node.addChild(path.substring(idx));
            }
            node.setData(path);
        }
    }

    @Nullable
    public String lookupOutputPath(File outputFile) {
        return this.lookupOutputPath(outputFile.getPath());
    }

    @Nullable
    public String lookupOutputPath(String filePath) {
        String path = FileUtil.toSystemIndependentName((String)filePath);
        Node node = this.myRoot;
        int idx = path.startsWith("/") ? 1 : 0;
        return OutputPathFinder.findOutputPath(path, idx, node);
    }

    @Nullable
    private static String findOutputPath(String path, int idx, Node node) {
        int slashIndex;
        String name;
        while ((node = node.getChild(name = (slashIndex = path.indexOf(47, idx)) < idx ? path.substring(idx) : path.substring(idx, slashIndex))) != null) {
            if (node.isOutputRoot()) {
                String candidate;
                if (node.hasChildren() && slashIndex > idx && (candidate = OutputPathFinder.findOutputPath(path, slashIndex + 1, node)) != null) {
                    return candidate;
                }
                return node.getData();
            }
            if (slashIndex < 0) {
                return null;
            }
            idx = slashIndex + 1;
        }
        return null;
    }

    public static void main(String[] args) {
        HashSet<File> set = new HashSet<File>();
        set.add(new File("/a/b/c"));
        set.add(new File("a/b/d"));
        set.add(new File("a/b/e"));
        set.add(new File("/a/b/f/g"));
        set.add(new File("/a/b/f/g/zzz"));
        OutputPathFinder finder = new OutputPathFinder(set);
        System.out.println(finder.lookupOutputPath(new File("a/b")));
        System.out.println(finder.lookupOutputPath(new File("a/b/c/dir1/dir2/File.class")));
        System.out.println(finder.lookupOutputPath(new File("a/b/d/dir1/dir2/File.class")));
        System.out.println(finder.lookupOutputPath(new File("a/b/jjjjj/dir1/dir2/File.class")));
        System.out.println(finder.lookupOutputPath(new File("a/b/e/File.class")));
        System.out.println(finder.lookupOutputPath(new File("a/b/File.class")));
        System.out.println(finder.lookupOutputPath(new File("/a/b/f/g/File.class")));
        System.out.println(finder.lookupOutputPath(new File("/a/b/f/g/ttt/yy/File.class")));
        System.out.println(finder.lookupOutputPath(new File("/a/b/f/g/zzz/File.class")));
        System.out.println(finder.lookupOutputPath(new File("/a/b/f/g/zzz/mmm/ttt/File.class")));
    }

    private static class Node {
        private final String myName;
        @Nullable
        private Object myChildren;

        private Node(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public boolean isOutputRoot() {
            return this.myChildren instanceof String || this.myChildren instanceof Pair;
        }

        public boolean hasChildren() {
            return this.myChildren instanceof Map || this.myChildren instanceof Pair;
        }

        @Nullable
        public String getData() {
            if (this.myChildren instanceof String) {
                return (String)this.myChildren;
            }
            if (this.myChildren instanceof Pair) {
                return (String)((Pair)this.myChildren).first;
            }
            return null;
        }

        public void setData(String path) {
            this.myChildren = this.myChildren != null ? (this.myChildren instanceof String ? path : new Pair((Object)path, this.myChildren instanceof Pair ? ((Pair)this.myChildren).second : this.myChildren)) : path;
        }

        public Node addChild(String childName) {
            Map<String, Node> map;
            if (this.myChildren == null) {
                Node node = new Node(childName);
                this.myChildren = node;
                return node;
            }
            if (this.myChildren instanceof String) {
                Node node = new Node(childName);
                this.myChildren = new Pair(this.myChildren, (Object)node);
                return node;
            }
            if (this.myChildren instanceof Map) {
                map = (HashMap<String, Node>)this.myChildren;
            } else if (this.myChildren instanceof Node) {
                Node existingChild = (Node)this.myChildren;
                map = new HashMap<String, Node>();
                this.myChildren = map;
                map.put(existingChild.getName(), existingChild);
            } else {
                Object children = ((Pair)this.myChildren).second;
                if (children instanceof Map) {
                    map = (Map)children;
                } else {
                    Node existingChild = (Node)children;
                    map = new HashMap();
                    this.myChildren = new Pair(((Pair)this.myChildren).first, map);
                    map.put(existingChild.getName(), existingChild);
                }
            }
            Node node = (Node)map.get(childName);
            if (node == null) {
                node = new Node(childName);
                map.put(childName, node);
            }
            return node;
        }

        @Nullable
        public Node getChild(String childName) {
            Object children;
            Object object = children = this.myChildren instanceof Pair ? ((Pair)this.myChildren).second : this.myChildren;
            if (children instanceof Node) {
                Node childNode = (Node)children;
                return childName.equals(childNode.getName()) ? childNode : null;
            }
            if (children instanceof Map) {
                return (Node)((Map)this.myChildren).get(childName);
            }
            return null;
        }
    }
}

