/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.apiAdapters;

import com.intellij.debugger.apiAdapters.ConnectionServiceWrapper;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.connect.Transport;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class TransportServiceWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.apiAdapters.TransportService");
    private final Object myDelegateObject;
    private final Class myDelegateClass;
    private static final String SOCKET_TRANSPORT_CLASS = SystemInfo.JAVA_VERSION.startsWith("1.4") ? "com.sun.tools.jdi.SocketTransport" : "com.sun.tools.jdi.SocketTransportService";
    private static final String SHMEM_TRANSPORT_CLASS = SystemInfo.JAVA_VERSION.startsWith("1.4") ? "com.sun.tools.jdi.SharedMemoryTransport" : "com.sun.tools.jdi.SharedMemoryTransportService";
    private final Map<String, Object> myListenAddresses = new HashMap<String, Object>();

    private TransportServiceWrapper(Class delegateClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.myDelegateClass = delegateClass;
        Constructor constructor = delegateClass.getDeclaredConstructor(ArrayUtil.EMPTY_CLASS_ARRAY);
        constructor.setAccessible(true);
        this.myDelegateObject = constructor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    private TransportServiceWrapper(Transport transportObj) {
        this.myDelegateClass = transportObj.getClass();
        this.myDelegateObject = transportObj;
    }

    public ConnectionServiceWrapper attach(String s) throws IOException {
        try {
            Method method = this.myDelegateClass.getMethod("attach", String.class);
            method.setAccessible(true);
            return new ConnectionServiceWrapper(method.invoke(this.myDelegateObject, s));
        }
        catch (NoSuchMethodException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            LOG.error((Throwable)e);
        }
        return null;
    }

    public String startListening() throws IOException {
        try {
            Method method = this.myDelegateClass.getMethod("startListening", ArrayUtil.EMPTY_CLASS_ARRAY);
            method.setAccessible(true);
            Object rv = method.invoke(this.myDelegateObject, ArrayUtil.EMPTY_OBJECT_ARRAY);
            String strValue = rv.toString();
            this.myListenAddresses.put(strValue, rv);
            return strValue;
        }
        catch (NoSuchMethodException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            LOG.error((Throwable)e);
        }
        return null;
    }

    public void stopListening(String address) throws IOException {
        try {
            Object value = this.myListenAddresses.get(address);
            if (value == null) {
                value = address;
            }
            Class<?> paramClass = value.getClass();
            Class<?> superClass = paramClass.getSuperclass();
            while (!Object.class.equals(superClass)) {
                paramClass = superClass;
                superClass = superClass.getSuperclass();
            }
            Method method = this.myDelegateClass.getMethod("stopListening", paramClass);
            method.setAccessible(true);
            method.invoke(this.myDelegateObject, value);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            LOG.error((Throwable)e);
        }
    }

    public String transportId() {
        if (SOCKET_TRANSPORT_CLASS.equals(this.myDelegateClass.getName())) {
            return "dt_socket";
        }
        if (SHMEM_TRANSPORT_CLASS.equals(this.myDelegateClass.getName())) {
            return "dt_shmem";
        }
        LOG.error("Unknown serivce");
        return "<unknown>";
    }

    public static TransportServiceWrapper getTransportService(boolean forceSocketTransport) throws ExecutionException {
        TransportServiceWrapper transport;
        block5: {
            try {
                try {
                    if (forceSocketTransport) {
                        transport = new TransportServiceWrapper(Class.forName(SOCKET_TRANSPORT_CLASS));
                        break block5;
                    }
                    transport = new TransportServiceWrapper(Class.forName(SHMEM_TRANSPORT_CLASS));
                }
                catch (UnsatisfiedLinkError e) {
                    transport = new TransportServiceWrapper(Class.forName(SOCKET_TRANSPORT_CLASS));
                }
            }
            catch (Exception e) {
                throw new ExecutionException(e.getClass().getName() + " : " + e.getMessage());
            }
        }
        return transport;
    }

    public static TransportServiceWrapper getTransportService(Transport transportObject) {
        return new TransportServiceWrapper(transportObject);
    }
}

