/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind myKind;
    private String myText;
    private final String myImports;

    public TextWithImportsImpl(PsiExpression expression) {
        this.myKind = CodeFragmentKind.EXPRESSION;
        String text = expression.getText();
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile instanceof PsiExpressionCodeFragment) {
            this.myText = text;
            this.myImports = ((JavaCodeFragment)containingFile).importsToString();
        } else {
            int separatorIndex = text.indexOf(13);
            if (separatorIndex >= 0) {
                this.myText = text.substring(0, separatorIndex);
                this.myImports = text.substring(separatorIndex + 1);
            } else {
                this.myText = text;
                this.myImports = "";
            }
        }
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text, @NotNull String imports) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/engine/evaluation/TextWithImportsImpl.<init> must not be null");
        }
        if (imports == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/debugger/engine/evaluation/TextWithImportsImpl.<init> must not be null");
        }
        this.myKind = kind;
        this.myText = text;
        this.myImports = imports;
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/engine/evaluation/TextWithImportsImpl.<init> must not be null");
        }
        this.myKind = kind;
        text = text.trim();
        int separatorIndex = text.indexOf(13);
        if (separatorIndex >= 0) {
            this.myText = text.substring(0, separatorIndex);
            this.myImports = text.substring(separatorIndex + 1);
        } else {
            this.myText = text;
            this.myImports = "";
        }
    }

    public CodeFragmentKind getKind() {
        return this.myKind;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getImports() {
        String string = this.myImports;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/engine/evaluation/TextWithImportsImpl.getImports must not return null");
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) {
            return false;
        }
        TextWithImportsImpl item = (TextWithImportsImpl)object;
        return Comparing.equal((String)item.myText, (String)this.myText) && Comparing.equal((String)item.myImports, (String)this.myImports);
    }

    public String toString() {
        return "".equals(this.myImports) ? this.myText : this.myText + '\r' + this.myImports;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isEmpty() {
        String text = this.getText();
        return text == null || "".equals(text.trim());
    }

    public void setText(String newText) {
        this.myText = newText;
    }
}

