/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UnBoxingEvaluator
implements Evaluator {
    private final Evaluator myOperand;
    private static final Map<String, Pair<String, String>> TYPES_TO_CONVERSION_METHOD_MAP = new HashMap();

    public static boolean isTypeUnboxable(String typeName) {
        return TYPES_TO_CONVERSION_METHOD_MAP.containsKey(typeName);
    }

    public UnBoxingEvaluator(Evaluator operand) {
        this.myOperand = operand;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        String valueTypeName;
        Pair<String, String> pair;
        Value result = (Value)this.myOperand.evaluate(context);
        if (result == null) {
            throw new EvaluateException("java.lang.NullPointerException: cannot unbox null value");
        }
        if (result instanceof ObjectReference && (pair = TYPES_TO_CONVERSION_METHOD_MAP.get(valueTypeName = result.type().name())) != null) {
            return UnBoxingEvaluator.convertToPrimitive(context, (ObjectReference)result, (String)pair.getFirst(), (String)pair.getSecond());
        }
        return result;
    }

    @Override
    @Nullable
    public Modifier getModifier() {
        return null;
    }

    private static Value convertToPrimitive(EvaluationContextImpl context, ObjectReference value, String conversionMethodName, String conversionMethodSignature) throws EvaluateException {
        DebugProcessImpl process = context.getDebugProcess();
        ClassType wrapperClass = (ClassType)value.referenceType();
        List<Method> methods = wrapperClass.methodsByName(conversionMethodName, conversionMethodSignature);
        if (methods.size() == 0) {
            throw new EvaluateException("Cannot convert to primitive value of type " + value.type() + ": Unable to find method " + conversionMethodName + conversionMethodSignature);
        }
        Method method = methods.get(0);
        return process.invokeMethod((EvaluationContext)context, value, method, new ArrayList());
    }

    static {
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Boolean", (Pair<String, String>)new Pair((Object)"booleanValue", (Object)"()Z"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Byte", (Pair<String, String>)new Pair((Object)"byteValue", (Object)"()B"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Character", (Pair<String, String>)new Pair((Object)"charValue", (Object)"()C"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Short", (Pair<String, String>)new Pair((Object)"shortValue", (Object)"()S"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Integer", (Pair<String, String>)new Pair((Object)"intValue", (Object)"()I"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Long", (Pair<String, String>)new Pair((Object)"longValue", (Object)"()J"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Float", (Pair<String, String>)new Pair((Object)"floatValue", (Object)"()F"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Double", (Pair<String, String>)new Pair((Object)"doubleValue", (Object)"()D"));
    }
}

