/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.ReferenceType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

class ReloadClassesWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.ReloadClassesWorker");
    private static final int CLASSES_CHUNK_SIZE = 100;
    private final DebuggerSession myDebuggerSession;
    private final HotSwapProgress myProgress;

    public ReloadClassesWorker(DebuggerSession session, HotSwapProgress progress) {
        this.myDebuggerSession = session;
        this.myProgress = progress;
    }

    private DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession.getProcess();
    }

    private void processException(Throwable e) {
        if (e.getMessage() != null) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, e.getMessage());
        }
        if (e instanceof ProcessCanceledException) {
            this.myProgress.addMessage(this.myDebuggerSession, 3, DebuggerBundle.message((String)"error.operation.canceled", (Object[])new Object[0]));
            return;
        }
        if (e instanceof UnsupportedOperationException) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.operation.not.supported.by.vm", (Object[])new Object[0]));
        } else if (e instanceof NoClassDefFoundError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.class.def.not.found", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else if (e instanceof VerifyError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.verification.error", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else if (e instanceof UnsupportedClassVersionError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.unsupported.class.version", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else if (e instanceof ClassFormatError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.class.format.error", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else if (e instanceof ClassCircularityError) {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.class.circularity.error", (Object[])new Object[]{e.getLocalizedMessage()}));
        } else {
            this.myProgress.addMessage(this.myDebuggerSession, 4, DebuggerBundle.message((String)"error.exception.while.reloading", (Object[])new Object[]{e.getClass().getName(), e.getLocalizedMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadClasses(Map<String, HotSwapFile> modifiedClasses) {
        if (modifiedClasses == null || modifiedClasses.size() == 0) {
            this.myProgress.addMessage(this.myDebuggerSession, 3, DebuggerBundle.message((String)"status.hotswap.loaded.classes.up.to.date", (Object[])new Object[0]));
            return;
        }
        final DebugProcessImpl debugProcess = this.getDebugProcess();
        final VirtualMachineProxyImpl virtualMachineProxy = debugProcess.getVirtualMachineProxy();
        if (virtualMachineProxy == null) {
            return;
        }
        final Project project = debugProcess.getProject();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
        breakpointManager.disableBreakpoints(debugProcess);
        virtualMachineProxy.suspend();
        try {
            HashMap<ReferenceType, byte[]> redefineMap = new HashMap<ReferenceType, byte[]>();
            int processedClassesCount = 0;
            final IOException[] _ex = new IOException[]{null};
            for (String qualifiedName : modifiedClasses.keySet()) {
                ++processedClassesCount;
                if (qualifiedName != null) {
                    this.myProgress.setText(qualifiedName);
                    this.myProgress.setFraction((double)processedClassesCount / (double)modifiedClasses.size());
                }
                _ex[0] = null;
                final HotSwapFile fileDescr = modifiedClasses.get(qualifiedName);
                byte[] buffer = (byte[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<byte[]>(){

                    public byte[] compute() {
                        try {
                            return fileDescr.file.contentsToByteArray();
                        }
                        catch (IOException e) {
                            _ex[0] = e;
                            return null;
                        }
                    }
                });
                if (buffer != null) {
                    List<ReferenceType> classes = virtualMachineProxy.classesByName(qualifiedName);
                    for (ReferenceType reference : classes) {
                        redefineMap.put(reference, buffer);
                    }
                } else {
                    this.reportProblem(qualifiedName, _ex[0]);
                }
                if (redefineMap.size() < 100) continue;
                try {
                    virtualMachineProxy.redefineClasses(redefineMap);
                }
                finally {
                    redefineMap.clear();
                }
            }
            if (redefineMap.size() > 0) {
                virtualMachineProxy.redefineClasses(redefineMap);
            }
            this.myProgress.setFraction(1.0);
            this.myProgress.addMessage(this.myDebuggerSession, 3, DebuggerBundle.message((String)"status.classes.reloaded", (Object[])new Object[]{modifiedClasses.size()}));
            if (LOG.isDebugEnabled()) {
                LOG.debug("classes reloaded");
            }
        }
        catch (Throwable e) {
            this.processException(e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
                breakpointManager.reloadBreakpoints();
                debugProcess.getRequestsManager().clearWarnings();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("requests updated");
                    LOG.debug("time stamp set");
                }
                ReloadClassesWorker.this.myDebuggerSession.refresh(false);
                debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        try {
                            breakpointManager.enableBreakpoints(debugProcess);
                        }
                        catch (Exception e) {
                            ReloadClassesWorker.this.processException(e);
                        }
                        try {
                            virtualMachineProxy.resume();
                        }
                        catch (Exception e) {
                            ReloadClassesWorker.this.processException(e);
                        }
                    }

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportProblem(String qualifiedName, @Nullable Exception ex) {
        String reason = null;
        if (ex != null) {
            reason = ex.getLocalizedMessage();
        }
        if (reason == null || reason.length() == 0) {
            reason = DebuggerBundle.message((String)"error.io.error", (Object[])new Object[0]);
        }
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append(qualifiedName).append(" : ").append(reason);
            this.myProgress.addMessage(this.myDebuggerSession, 4, buf.toString());
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }
}

