/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class Breakpoint
extends FilteredRequestor
implements ClassPrepareRequestor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.Breakpoint");
    public boolean ENABLED = true;
    public boolean LOG_ENABLED = false;
    public boolean LOG_EXPRESSION_ENABLED = false;
    private TextWithImports myLogMessage = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
    @NonNls
    private static final String LOG_MESSAGE_OPTION_NAME = "LOG_MESSAGE";
    public static final Breakpoint[] EMPTY_ARRAY = new Breakpoint[0];
    protected boolean myCachedVerifiedState = false;

    protected Breakpoint(Project project) {
        super(project);
        this.SUSPEND_POLICY = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().getDefaultSuspendPolicy(this.getCategory());
    }

    public abstract PsiClass getPsiClass();

    public abstract void createRequest(DebugProcessImpl var1);

    public abstract void processClassPrepare(DebugProcess var1, ReferenceType var2);

    public abstract String getDisplayName();

    @Nullable
    public String getClassName() {
        return null;
    }

    public void markVerified(boolean isVerified) {
        this.myCachedVerifiedState = isVerified;
    }

    @Nullable
    public String getShortClassName() {
        String className = this.getClassName();
        if (className != null) {
            int dotIndex = className.lastIndexOf(46);
            return dotIndex >= 0 && dotIndex + 1 < className.length() ? className.substring(dotIndex + 1) : className;
        }
        return className;
    }

    @Nullable
    public String getPackageName() {
        return null;
    }

    public abstract Icon getIcon();

    public abstract void reload();

    public abstract String getEventMessage(LocatableEvent var1);

    public abstract boolean isValid();

    public abstract Key<? extends Breakpoint> getCategory();

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classToBeLoaded);
        List<ReferenceType> list = debugProcess.getVirtualMachineProxy().classesByName(classToBeLoaded);
        for (ReferenceType aList : list) {
            ReferenceType refType = aList;
            if (!refType.isPrepared()) continue;
            this.processClassPrepare(debugProcess, refType);
        }
    }

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, SourcePosition classPosition) {
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classPosition);
        List<ReferenceType> list = debugProcess.getPositionManager().getAllClasses(classPosition);
        for (ReferenceType aList : list) {
            ReferenceType refType = aList;
            if (!refType.isPrepared()) continue;
            this.processClassPrepare(debugProcess, refType);
        }
    }

    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        StackFrameProxyImpl stackFrameProxy;
        ThreadReferenceProxyImpl thread = context.getThread();
        if (thread != null && (stackFrameProxy = thread.frame(0)) != null) {
            return stackFrameProxy.thisObject();
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl context = action.getSuspendContext();
        if (!this.isValid()) {
            context.getDebugProcess().getRequestsManager().deleteRequest(this);
            return false;
        }
        String[] title = new String[]{DebuggerBundle.message((String)"title.error.evaluating.breakpoint.condition", (Object[])new Object[0])};
        try {
            StackFrameProxyImpl frameProxy = context.getThread().frame(0);
            if (frameProxy == null) {
                return false;
            }
            EvaluationContextImpl evaluationContext = new EvaluationContextImpl(action.getSuspendContext(), frameProxy, this.getThisObject(context, event));
            if (!this.evaluateCondition(evaluationContext, event)) {
                return false;
            }
            title[0] = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.action", (Object[])new Object[0]);
            this.runAction(evaluationContext, event);
        }
        catch (EvaluateException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.out.println(ex.getMessage());
                return false;
            }
            throw new LocatableEventRequestor.EventProcessingException(title[0], ex.getMessage(), ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAction(final EvaluationContextImpl context, LocatableEvent event) {
        if (this.LOG_ENABLED || this.LOG_EXPRESSION_ENABLED) {
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                if (this.LOG_ENABLED) {
                    buf.append(this.getEventMessage(event));
                    buf.append("\n");
                }
                DebugProcessImpl debugProcess = context.getDebugProcess();
                final TextWithImports expressionToEvaluate = this.getLogMessage();
                if (this.LOG_EXPRESSION_ENABLED && expressionToEvaluate != null && !"".equals(expressionToEvaluate.getText())) {
                    if (!debugProcess.isAttached()) {
                        return;
                    }
                    try {
                        ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.getProject(), new EvaluatingComputable<ExpressionEvaluator>(){

                            @Override
                            public ExpressionEvaluator compute() throws EvaluateException {
                                return EvaluatorBuilderImpl.getInstance().build(expressionToEvaluate, ContextUtil.getContextElement((StackFrameContext)context), ContextUtil.getSourcePosition((StackFrameContext)context));
                            }
                        });
                        String result = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)evaluator.evaluate(context));
                        buf.append(result);
                    }
                    catch (EvaluateException e) {
                        buf.append(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]));
                        buf.append(" \"");
                        buf.append(expressionToEvaluate);
                        buf.append("\"");
                        buf.append(" : ");
                        buf.append(e.getMessage());
                    }
                    buf.append("\n");
                }
                if (buf.length() > 0) {
                    debugProcess.printToConsole(buf.toString());
                }
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
        }
    }

    public final void updateUI() {
        this.updateUI(EmptyRunnable.getInstance());
    }

    public void updateUI(Runnable afterUpdate) {
    }

    public void delete() {
        RequestManagerImpl.deleteRequests(this);
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        super.readExternal(parentNode);
        String logMessage = JDOMExternalizerUtil.readField((Element)parentNode, (String)LOG_MESSAGE_OPTION_NAME);
        if (logMessage != null) {
            this.setLogMessage(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, logMessage));
        }
    }

    @Override
    public void writeExternal(Element parentNode) throws WriteExternalException {
        super.writeExternal(parentNode);
        JDOMExternalizerUtil.writeField((Element)parentNode, (String)LOG_MESSAGE_OPTION_NAME, (String)this.getLogMessage().toString());
    }

    public TextWithImports getLogMessage() {
        return this.myLogMessage;
    }

    public void setLogMessage(TextWithImports logMessage) {
        this.myLogMessage = logMessage;
    }
}

