/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MethodBreakpointPropertiesPanel
extends BreakpointPropertiesPanel {
    private JCheckBox myWatchEntryCheckBox;
    private JCheckBox myWatchExitCheckBox;

    public MethodBreakpointPropertiesPanel(Project project) {
        super(project, MethodBreakpoint.CATEGORY);
    }

    @Override
    protected JComponent createSpecialBox() {
        this.myWatchEntryCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.method.breakpoint.properties.panel.method.entry", (Object[])new Object[0]));
        this.myWatchExitCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.method.breakpoint.properties.panel.method.exit", (Object[])new Object[0]));
        Box watchBox = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchEntryCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myWatchExitCheckBox, "North");
        watchBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        _panel0.add((Component)watchBox, "Center");
        _panel0.add(Box.createHorizontalStrut(3), "West");
        _panel0.add(Box.createHorizontalStrut(3), "East");
        _panel.add((Component)_panel0, "North");
        _panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), DebuggerBundle.message((String)"label.group.watch.events", (Object[])new Object[0])));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox toCheck = null;
                if (!MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox.isSelected() && !MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox.isSelected()) {
                    Object source = e.getSource();
                    if (MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox.equals(source)) {
                        toCheck = MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox;
                    } else if (MethodBreakpointPropertiesPanel.this.myWatchExitCheckBox.equals(source)) {
                        toCheck = MethodBreakpointPropertiesPanel.this.myWatchEntryCheckBox;
                    }
                    if (toCheck != null) {
                        toCheck.setSelected(true);
                    }
                }
            }
        };
        this.myWatchEntryCheckBox.addActionListener(listener);
        this.myWatchExitCheckBox.addActionListener(listener);
        return _panel;
    }

    @Override
    public void initFrom(Breakpoint breakpoint) {
        super.initFrom(breakpoint);
        if (breakpoint instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)breakpoint;
            this.myWatchEntryCheckBox.setSelected(methodBreakpoint.WATCH_ENTRY);
            this.myWatchExitCheckBox.setSelected(methodBreakpoint.WATCH_EXIT);
        } else if (breakpoint instanceof WildcardMethodBreakpoint) {
            WildcardMethodBreakpoint methodBreakpoint = (WildcardMethodBreakpoint)breakpoint;
            this.myWatchEntryCheckBox.setSelected(methodBreakpoint.WATCH_ENTRY);
            this.myWatchExitCheckBox.setSelected(methodBreakpoint.WATCH_EXIT);
        }
    }

    @Override
    public void saveTo(Breakpoint breakpoint, Runnable afterUpdate) {
        if (breakpoint instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)breakpoint;
            methodBreakpoint.WATCH_ENTRY = this.myWatchEntryCheckBox.isSelected();
            methodBreakpoint.WATCH_EXIT = this.myWatchExitCheckBox.isSelected();
        } else if (breakpoint instanceof WildcardMethodBreakpoint) {
            WildcardMethodBreakpoint methodBreakpoint = (WildcardMethodBreakpoint)breakpoint;
            methodBreakpoint.WATCH_ENTRY = this.myWatchEntryCheckBox.isSelected();
            methodBreakpoint.WATCH_EXIT = this.myWatchExitCheckBox.isSelected();
        }
        super.saveTo(breakpoint, afterUpdate);
    }
}

