/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.ExecutionUtil");
    private static final Icon INVALID_CONFIGURATION = IconLoader.getIcon((String)"/runConfigurations/invalidConfigurationLayer.png");

    private ExecutionUtil() {
    }

    @Nullable
    public static ProgramRunner getRunner(String executorId, RunnerAndConfigurationSettingsImpl configuration) {
        return RunnerRegistry.getInstance().getRunner(executorId, (RunProfile)configuration.getConfiguration());
    }

    public static void executeConfiguration(@NotNull Project project, @NotNull RunnerAndConfigurationSettingsImpl configuration, @NotNull Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutionUtil.executeConfiguration must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ExecutionUtil.executeConfiguration must not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ExecutionUtil.executeConfiguration must not be null");
        }
        ProgramRunner runner = ExecutionUtil.getRunner(executor.getId(), configuration);
        LOG.assertTrue(runner != null, (Object)"Runner MUST not be null!");
        if (!RunManagerImpl.canRunConfiguration(configuration, executor)) {
            boolean result = RunDialog.editConfiguration(project, configuration, "Edit configuration", executor.getActionName(), executor.getIcon());
            if (!result) {
                return;
            }
            while (!RunManagerImpl.canRunConfiguration(configuration, executor) && 0 == Messages.showOkCancelDialog((Project)project, (String)"Configuration is still wrong. Do you want to edit it again?", (String)"Change configuration settings", (Icon)Messages.getErrorIcon())) {
                boolean result2 = RunDialog.editConfiguration(project, configuration, "Edit configuration", executor.getActionName(), executor.getIcon());
                if (result2) continue;
                return;
            }
        }
        try {
            runner.execute(executor, new ExecutionEnvironment(runner, (RunnerAndConfigurationSettings)configuration, SimpleDataContext.getProjectContext(project)));
        }
        catch (RunCanceledByUserException e) {
        }
        catch (ExecutionException e1) {
            Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"error.running.configuration.with.error.error.message", (Object[])new Object[]{configuration.getName(), e1.getMessage()}), (String)ExecutionBundle.message((String)"run.error.message.title", (Object[])new Object[0]));
        }
    }

    public static Icon getConfigurationIcon(Project project, RunnerAndConfigurationSettings settings, boolean invalid) {
        Icon configurationIcon;
        RunManager runManager = RunManager.getInstance((Project)project);
        RunConfiguration configuration = settings.getConfiguration();
        Icon icon = settings.getFactory().getIcon(configuration);
        LOG.assertTrue(icon != null, (Object)"Icon should not be null!");
        Icon icon2 = configurationIcon = runManager.isTemporary(configuration) ? IconLoader.getTransparentIcon((Icon)icon, (float)0.3f) : icon;
        if (invalid) {
            return LayeredIcon.create((Icon)configurationIcon, (Icon)INVALID_CONFIGURATION);
        }
        return configurationIcon;
    }

    public static Icon getConfigurationIcon(Project project, RunnerAndConfigurationSettings settings) {
        try {
            settings.checkSettings();
            return ExecutionUtil.getConfigurationIcon(project, settings, false);
        }
        catch (RuntimeConfigurationException ex) {
            return ExecutionUtil.getConfigurationIcon(project, settings, true);
        }
    }

    public static String shortenName(String name, int toBeAdded) {
        if (name == null) {
            return "";
        }
        int symbols = Math.max(10, 20 - toBeAdded);
        if (name.length() < symbols) {
            return name;
        }
        return name.substring(0, symbols) + "...";
    }
}

