/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfigurationProducer
extends JavaRuntimeConfigurationProducerBase
implements Cloneable {
    private PsiElement myPsiElement = null;
    public static final RuntimeConfigurationProducer PROTOTYPE = new ApplicationConfigurationProducer();

    public ApplicationConfigurationProducer() {
        super((ConfigurationType)ApplicationConfigurationType.getInstance());
    }

    @Override
    public PsiElement getSourceElement() {
        return this.myPsiElement;
    }

    @Override
    protected RunnerAndConfigurationSettingsImpl createConfigurationByElement(Location location, ConfigurationContext context) {
        PsiClass aClass;
        PsiMethod method;
        PsiElement element;
        location = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        PsiElement currentElement = element = location.getPsiElement();
        while ((method = ApplicationConfigurationProducer.findMain(currentElement)) != null) {
            aClass = method.getContainingClass();
            if (ConfigurationUtil.MAIN_CLASS.value((Object)aClass)) {
                this.myPsiElement = method;
                return this.createConfiguration(aClass, context);
            }
            currentElement = method.getParent();
        }
        aClass = ApplicationConfigurationType.getMainClass(element);
        if (aClass == null) {
            return null;
        }
        this.myPsiElement = aClass;
        return this.createConfiguration(aClass, context);
    }

    private RunnerAndConfigurationSettingsImpl createConfiguration(PsiClass aClass, ConfigurationContext context) {
        Project project = aClass.getProject();
        RunnerAndConfigurationSettingsImpl settings = this.cloneTemplateConfiguration(project, context);
        ApplicationConfiguration configuration = (ApplicationConfiguration)settings.getConfiguration();
        configuration.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass);
        configuration.setName(configuration.getGeneratedName());
        this.setupConfigurationModule(context, configuration);
        RunConfigurationExtension.patchCreatedConfiguration(configuration);
        this.copyStepsBeforeRun(project, (RunConfiguration)configuration);
        return settings;
    }

    @Nullable
    private static PsiMethod findMain(PsiElement element) {
        PsiMethod method;
        while ((method = ApplicationConfigurationProducer.getContainingMethod(element)) != null) {
            if (PsiMethodUtil.isMainMethod((PsiMethod)method)) {
                return method;
            }
            element = method.getParent();
        }
        return null;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

