/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RunnerAndConfigurationSettingsImpl
implements JDOMExternalizable,
Cloneable,
RunnerAndConfigurationSettings,
Comparable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.RunnerAndConfigurationSettings");
    @NonNls
    private static final String RUNNER_ELEMENT = "RunnerSettings";
    @NonNls
    private static final String CONFIGURATION_ELEMENT = "ConfigurationWrapper";
    @NonNls
    private static final String RUNNER_ID = "RunnerId";
    @NonNls
    private static final String CONFIGURATION_TYPE_ATTRIBUTE = "type";
    @NonNls
    private static final String FACTORY_NAME_ATTRIBUTE = "factoryName";
    @NonNls
    private static final String TEMPLATE_FLAG_ATTRIBUTE = "default";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    protected static final String DUMMY_ELEMENT_NANE = "dummy";
    @NonNls
    private static final String TEMPORARY_ATTRIBUTE = "temporary";
    @NonNls
    private static final String TEMP_CONFIGURATION = "tempConfiguration";
    private final RunManagerImpl myManager;
    private RunConfiguration myConfiguration;
    private boolean myIsTemplate;
    private final Map<ProgramRunner, RunnerSettings> myRunnerSettings = new HashMap<ProgramRunner, RunnerSettings>();
    private List<Element> myUnloadedRunnerSettings = null;
    private final Map<ProgramRunner, ConfigurationPerRunnerSettings> myConfigurationPerRunnerSettings = new HashMap<ProgramRunner, ConfigurationPerRunnerSettings>();
    private List<Element> myUnloadedConfigurationPerRunnerSettings = null;
    private boolean myTemporary;

    public RunnerAndConfigurationSettingsImpl(RunManagerImpl manager) {
        this.myManager = manager;
    }

    public RunnerAndConfigurationSettingsImpl(RunManagerImpl manager, RunConfiguration configuration, boolean isTemplate) {
        this.myManager = manager;
        this.myConfiguration = configuration;
        this.myIsTemplate = isTemplate;
    }

    @Nullable
    public ConfigurationFactory getFactory() {
        return this.myConfiguration == null ? null : this.myConfiguration.getFactory();
    }

    public boolean isTemplate() {
        return this.myIsTemplate;
    }

    public boolean isTemporary() {
        return this.myTemporary;
    }

    public void setTemporary(boolean temporary) {
        this.myTemporary = temporary;
    }

    public RunConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public Factory<RunnerAndConfigurationSettingsImpl> createFactory() {
        return new Factory<RunnerAndConfigurationSettingsImpl>(){

            public RunnerAndConfigurationSettingsImpl create() {
                RunConfiguration configuration = RunnerAndConfigurationSettingsImpl.this.myConfiguration.getFactory().createConfiguration(ExecutionBundle.message((String)"default.run.configuration.name", (Object[])new Object[0]), RunnerAndConfigurationSettingsImpl.this.myConfiguration);
                return new RunnerAndConfigurationSettingsImpl(RunnerAndConfigurationSettingsImpl.this.myManager, configuration, false);
            }
        };
    }

    public void setName(String name) {
        this.myConfiguration.setName(name);
    }

    public String getName() {
        return this.myConfiguration.getName();
    }

    @Nullable
    private ConfigurationFactory getFactory(Element element) {
        String typeName = element.getAttributeValue(CONFIGURATION_TYPE_ATTRIBUTE);
        String factoryName = element.getAttributeValue(FACTORY_NAME_ATTRIBUTE);
        return this.myManager.getFactory(typeName, factoryName);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myIsTemplate = Boolean.valueOf(element.getAttributeValue(TEMPLATE_FLAG_ATTRIBUTE));
        this.myTemporary = Boolean.valueOf(element.getAttributeValue(TEMPORARY_ATTRIBUTE)) != false || TEMP_CONFIGURATION.equals(element.getName());
        ConfigurationFactory factory = this.getFactory(element);
        if (factory == null) {
            return;
        }
        if (this.myIsTemplate) {
            this.myConfiguration = this.myManager.getConfigurationTemplate(factory).getConfiguration();
        } else {
            String name = element.getAttributeValue(NAME_ATTR);
            this.myConfiguration = this.myManager.doCreateConfiguration(name, factory);
        }
        this.myConfiguration.readExternal(element);
        List runners = element.getChildren(RUNNER_ELEMENT);
        this.myUnloadedRunnerSettings = null;
        for (Object runner1 : runners) {
            Element runnerElement = (Element)runner1;
            String id = runnerElement.getAttributeValue(RUNNER_ID);
            ProgramRunner runner = RunnerRegistry.getInstance().findRunnerById(id);
            if (runner != null) {
                RunnerSettings settings = this.createRunnerSettings(runner);
                settings.readExternal(runnerElement);
                this.myRunnerSettings.put(runner, settings);
                continue;
            }
            if (this.myUnloadedRunnerSettings == null) {
                this.myUnloadedRunnerSettings = new ArrayList<Element>(1);
            }
            this.myUnloadedRunnerSettings.add(runnerElement);
        }
        List configurations = element.getChildren(CONFIGURATION_ELEMENT);
        this.myUnloadedConfigurationPerRunnerSettings = null;
        for (Object configuration : configurations) {
            Element configurationElement = (Element)configuration;
            String id = configurationElement.getAttributeValue(RUNNER_ID);
            ProgramRunner runner = RunnerRegistry.getInstance().findRunnerById(id);
            if (runner != null) {
                ConfigurationPerRunnerSettings settings = new ConfigurationPerRunnerSettings(id, this.myConfiguration.createRunnerSettings((ConfigurationInfoProvider)new InfoProvider(runner)));
                settings.readExternal(configurationElement);
                this.myConfigurationPerRunnerSettings.put(runner, settings);
                continue;
            }
            if (this.myUnloadedConfigurationPerRunnerSettings == null) {
                this.myUnloadedConfigurationPerRunnerSettings = new ArrayList<Element>(1);
            }
            this.myUnloadedConfigurationPerRunnerSettings.add(configurationElement);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        ConfigurationFactory factory = this.myConfiguration.getFactory();
        if (!(this.myConfiguration instanceof UnknownRunConfiguration)) {
            element.setAttribute(TEMPLATE_FLAG_ATTRIBUTE, String.valueOf(this.myIsTemplate));
            if (!this.myIsTemplate) {
                element.setAttribute(NAME_ATTR, this.myConfiguration.getName());
            }
            element.setAttribute(CONFIGURATION_TYPE_ATTRIBUTE, factory.getType().getId());
            element.setAttribute(FACTORY_NAME_ATTRIBUTE, factory.getName());
            if (this.myTemporary) {
                element.setAttribute(TEMPORARY_ATTRIBUTE, Boolean.toString(this.myTemporary));
            }
        }
        this.myConfiguration.writeExternal(element);
        if (!(this.myConfiguration instanceof UnknownRunConfiguration)) {
            Comparator<Element> runnerComparator = RunnerAndConfigurationSettingsImpl.createRunnerComparator();
            this.writeRunnerSettings(runnerComparator, element);
            this.writeConfigurationPerRunnerSettings(runnerComparator, element);
        }
    }

    private void writeConfigurationPerRunnerSettings(Comparator<Element> runnerComparator, Element element) throws WriteExternalException {
        ArrayList<Element> configurationPerRunnerSettings = new ArrayList<Element>();
        for (ProgramRunner runner : this.myConfigurationPerRunnerSettings.keySet()) {
            ConfigurationPerRunnerSettings settings = this.myConfigurationPerRunnerSettings.get(runner);
            Element runnerElement = new Element(CONFIGURATION_ELEMENT);
            settings.writeExternal(runnerElement);
            runnerElement.setAttribute(RUNNER_ID, runner.getRunnerId());
            configurationPerRunnerSettings.add(runnerElement);
        }
        if (this.myUnloadedConfigurationPerRunnerSettings != null) {
            for (Element unloadedCRunnerSetting : this.myUnloadedConfigurationPerRunnerSettings) {
                configurationPerRunnerSettings.add((Element)unloadedCRunnerSetting.clone());
            }
        }
        Collections.sort(configurationPerRunnerSettings, runnerComparator);
        for (Element runnerConfigurationSetting : configurationPerRunnerSettings) {
            element.addContent(runnerConfigurationSetting);
        }
    }

    private void writeRunnerSettings(Comparator<Element> runnerComparator, Element element) throws WriteExternalException {
        ArrayList<Element> runnerSettings = new ArrayList<Element>();
        for (ProgramRunner runner : this.myRunnerSettings.keySet()) {
            RunnerSettings settings = this.myRunnerSettings.get(runner);
            Element runnerElement = new Element(RUNNER_ELEMENT);
            settings.writeExternal(runnerElement);
            runnerElement.setAttribute(RUNNER_ID, runner.getRunnerId());
            runnerSettings.add(runnerElement);
        }
        if (this.myUnloadedRunnerSettings != null) {
            for (Element unloadedRunnerSetting : this.myUnloadedRunnerSettings) {
                runnerSettings.add((Element)unloadedRunnerSetting.clone());
            }
        }
        Collections.sort(runnerSettings, runnerComparator);
        for (Element runnerSetting : runnerSettings) {
            element.addContent(runnerSetting);
        }
    }

    public void checkSettings() throws RuntimeConfigurationException {
        this.checkSettings(null);
    }

    public void checkSettings(@Nullable Executor executor) throws RuntimeConfigurationException {
        this.myConfiguration.checkConfiguration();
        if (this.myConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase runConfigurationBase = (RunConfigurationBase)this.myConfiguration;
            HashSet<ProgramRunner> runners = new HashSet<ProgramRunner>();
            runners.addAll(this.myRunnerSettings.keySet());
            runners.addAll(this.myConfigurationPerRunnerSettings.keySet());
            for (ProgramRunner runner : runners) {
                if (executor != null && !runner.canRun(executor.getId(), (RunProfile)this.myConfiguration)) continue;
                runConfigurationBase.checkRunnerSettings(runner, this.myRunnerSettings.get(runner), this.myConfigurationPerRunnerSettings.get(runner));
            }
        }
    }

    private static Comparator<Element> createRunnerComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                String attributeValue1 = o1.getAttributeValue(RunnerAndConfigurationSettingsImpl.RUNNER_ID);
                if (attributeValue1 == null) {
                    return 1;
                }
                String attributeValue2 = o2.getAttributeValue(RunnerAndConfigurationSettingsImpl.RUNNER_ID);
                if (attributeValue2 == null) {
                    return -1;
                }
                return attributeValue1.compareTo(attributeValue2);
            }
        };
    }

    public RunnerSettings getRunnerSettings(ProgramRunner runner) {
        RunnerSettings settings = this.myRunnerSettings.get(runner);
        if (settings == null) {
            settings = this.createRunnerSettings(runner);
            this.myRunnerSettings.put(runner, settings);
        }
        return settings;
    }

    public ConfigurationPerRunnerSettings getConfigurationSettings(ProgramRunner runner) {
        ConfigurationPerRunnerSettings settings = this.myConfigurationPerRunnerSettings.get(runner);
        if (settings == null) {
            settings = new ConfigurationPerRunnerSettings(runner.getRunnerId(), this.myConfiguration.createRunnerSettings((ConfigurationInfoProvider)new InfoProvider(runner)));
            this.myConfigurationPerRunnerSettings.put(runner, settings);
        }
        return settings;
    }

    @Nullable
    public ConfigurationType getType() {
        return this.myConfiguration == null ? null : this.myConfiguration.getType();
    }

    public RunnerAndConfigurationSettingsImpl clone() {
        RunnerAndConfigurationSettingsImpl copy = new RunnerAndConfigurationSettingsImpl(this.myManager, this.myConfiguration.clone(), false);
        copy.importRunnerAndConfigurationSettings(this);
        return copy;
    }

    public void importRunnerAndConfigurationSettings(RunnerAndConfigurationSettingsImpl template) {
        try {
            Element temp;
            RunnerSettings data;
            for (ProgramRunner runner : template.myRunnerSettings.keySet()) {
                data = this.createRunnerSettings(runner);
                this.myRunnerSettings.put(runner, data);
                temp = new Element(DUMMY_ELEMENT_NANE);
                template.myRunnerSettings.get(runner).writeExternal(temp);
                data.readExternal(temp);
            }
            for (ProgramRunner runner : template.myConfigurationPerRunnerSettings.keySet()) {
                data = new ConfigurationPerRunnerSettings(runner.getRunnerId(), this.myConfiguration.createRunnerSettings((ConfigurationInfoProvider)new InfoProvider(runner)));
                this.myConfigurationPerRunnerSettings.put(runner, (ConfigurationPerRunnerSettings)data);
                temp = new Element(DUMMY_ELEMENT_NANE);
                template.myConfigurationPerRunnerSettings.get(runner).writeExternal(temp);
                data.readExternal(temp);
            }
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    private RunnerSettings createRunnerSettings(ProgramRunner runner) {
        return new RunnerSettings(runner.createConfigurationData((ConfigurationInfoProvider)new InfoProvider(runner)), (RunProfile)this.myConfiguration);
    }

    public int compareTo(Object o) {
        if (o instanceof RunnerAndConfigurationSettings) {
            return this.getName().compareTo(((RunnerAndConfigurationSettings)o).getName());
        }
        return 0;
    }

    private class InfoProvider
    implements ConfigurationInfoProvider {
        private final ProgramRunner myRunner;

        public InfoProvider(ProgramRunner runner) {
            this.myRunner = runner;
        }

        public ProgramRunner getRunner() {
            return this.myRunner;
        }

        public RunConfiguration getConfiguration() {
            return RunnerAndConfigurationSettingsImpl.this.myConfiguration;
        }

        public RunnerSettings getRunnerSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getRunnerSettings(this.myRunner);
        }

        public ConfigurationPerRunnerSettings getConfigurationSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getConfigurationSettings(this.myRunner);
        }
    }
}

