/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nullable;

public abstract class JavaRuntimeConfigurationProducerBase
extends RuntimeConfigurationProducer {
    protected JavaRuntimeConfigurationProducerBase(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected static PsiMethod getContainingMethod(PsiElement element) {
        while (element != null && !(element instanceof PsiMethod)) {
            element = element.getParent();
        }
        return (PsiMethod)element;
    }

    @Nullable
    protected static PsiPackage checkPackage(PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        Project project = element.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (element instanceof PsiPackage) {
            PsiDirectory[] directories;
            PsiPackage aPackage = (PsiPackage)element;
            for (PsiDirectory directory : directories = aPackage.getDirectories(GlobalSearchScope.projectScope((Project)project))) {
                if (!JavaRuntimeConfigurationProducerBase.isSource(directory, fileIndex)) continue;
                return aPackage;
            }
            return null;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            return JavaRuntimeConfigurationProducerBase.isSource(directory, fileIndex) ? JavaDirectoryService.getInstance().getPackage(directory) : null;
        }
        return null;
    }

    private static boolean isSource(PsiDirectory directory, ProjectFileIndex fileIndex) {
        VirtualFile virtualFile = directory.getVirtualFile();
        return fileIndex.getSourceRootForFile(virtualFile) != null;
    }

    protected TestSearchScope setupPackageConfiguration(ConfigurationContext context, Project project, ModuleBasedConfiguration configuration, TestSearchScope scope) {
        this.copyStepsBeforeRun(project, (RunConfiguration)configuration);
        if (scope != TestSearchScope.WHOLE_PROJECT && !this.setupConfigurationModule(context, configuration)) {
            return TestSearchScope.WHOLE_PROJECT;
        }
        return scope;
    }

    protected boolean setupConfigurationModule(@Nullable ConfigurationContext context, ModuleBasedConfiguration configuration) {
        if (context != null) {
            RunnerAndConfigurationSettingsImpl template = ((RunManagerImpl)context.getRunManager()).getConfigurationTemplate(this.getConfigurationFactory());
            Module contextModule = context.getModule();
            Module predefinedModule = ((ModuleBasedConfiguration)template.getConfiguration()).getConfigurationModule().getModule();
            if (predefinedModule != null) {
                configuration.setModule(predefinedModule);
                return true;
            }
            if (configuration.getConfigurationModule().getModule() == null && contextModule != null) {
                configuration.setModule(contextModule);
                return true;
            }
        }
        return false;
    }
}

