/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodLocation
extends Location<PsiMethod> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.info.MethodLocation");
    private final Project myProject;
    @NotNull
    private final PsiMethod myMethod;
    private final Location<PsiClass> myClassLocation;

    public MethodLocation(@NotNull Project project, @NotNull PsiMethod method, @NotNull Location<PsiClass> classLocation) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit2/info/MethodLocation.<init> must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/junit2/info/MethodLocation.<init> must not be null");
        }
        if (classLocation == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/junit2/info/MethodLocation.<init> must not be null");
        }
        this.myProject = project;
        this.myMethod = method;
        this.myClassLocation = classLocation;
    }

    public static MethodLocation elementInClass(PsiMethod psiElement, PsiClass psiClass) {
        Location classLocation = PsiLocation.fromPsiElement((PsiElement)psiClass);
        return new MethodLocation(classLocation.getProject(), psiElement, (Location<PsiClass>)classLocation);
    }

    @NotNull
    public PsiMethod getPsiElement() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/junit2/info/MethodLocation.getPsiElement must not return null");
        }
        return psiMethod;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/junit2/info/MethodLocation.getProject must not return null");
        }
        return project;
    }

    @Nullable
    public Module getModule() {
        return ModuleUtil.findModuleForPsiElement((PsiElement)this.myMethod);
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.myClassLocation.getPsiElement();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T extends PsiElement> Iterator<Location<T>> getAncestors(final Class<T> ancestorClass, boolean strict) {
        Iterator iterator;
        final Iterator fromClass = this.myClassLocation.getAncestors(ancestorClass, false);
        if (strict) {
            iterator = fromClass;
            if (iterator == null) throw new IllegalStateException("@NotNull method com/intellij/execution/junit2/info/MethodLocation.getAncestors must not return null");
            return iterator;
        }
        iterator = new Iterator<Location<T>>(){
            private boolean myFirstStep;
            {
                this.myFirstStep = ancestorClass.isInstance(MethodLocation.this.myMethod);
            }

            @Override
            public boolean hasNext() {
                return this.myFirstStep || fromClass.hasNext();
            }

            @Override
            public Location<T> next() {
                MethodLocation location = this.myFirstStep ? MethodLocation.this : (Location)fromClass.next();
                this.myFirstStep = false;
                return location;
            }

            @Override
            public void remove() {
                LOG.assertTrue(false);
            }
        };
        if (iterator != null) return iterator;
        throw new IllegalStateException("@NotNull method com/intellij/execution/junit2/info/MethodLocation.getAncestors must not return null");
    }
}

