/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.segments;

import com.intellij.execution.junit.SegmentedInputStreamReader;
import com.intellij.execution.junit2.SegmentedInputStream;
import com.intellij.execution.junit2.segments.DeferredActionsQueue;
import com.intellij.execution.junit2.segments.DispatchListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class Extractor {
    private DeferredActionsQueue myFulfilledWorkGate = null;
    private final SegmentedInputStream myStream;

    public Extractor(InputStream stream, Charset charset) {
        this.myStream = new SegmentedInputStream(stream, charset);
    }

    public void setDispatchListener(DispatchListener listener) {
        this.myFulfilledWorkGate.setDispactchListener(listener);
    }

    public void setPacketDispatcher(final PacketProcessor packetProcessor, final DeferredActionsQueue queue) {
        this.myFulfilledWorkGate = new DeferredActionsQueue(){

            @Override
            public void addLast(final Runnable runnable) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        queue.addLast(runnable);
                    }
                }, ModalityState.NON_MODAL);
            }

            @Override
            public void setDispactchListener(DispatchListener listener) {
                queue.setDispactchListener(listener);
            }
        };
        this.myStream.setEventsDispatcher(new PacketProcessor(){

            public void processPacket(final String packet) {
                Extractor.this.myFulfilledWorkGate.addLast(new Runnable(){

                    @Override
                    public void run() {
                        packetProcessor.processPacket(packet);
                    }
                });
            }
        });
    }

    public Reader createReader() {
        return new SegmentedInputStreamReader(this.myStream);
    }
}

