/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.diagnostic.Logger;
import java.util.EmptyStackException;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestSuiteStack {
    private static final Logger LOG = Logger.getInstance((String)TestSuiteStack.class.getName());
    @NonNls
    private static final String EMPTY = "empty";
    private final Stack<SMTestProxy> myStack = new Stack();

    public void pushSuite(@NotNull SMTestProxy suite) {
        if (suite == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/TestSuiteStack.pushSuite must not be null");
        }
        this.myStack.push(suite);
    }

    @Nullable
    public SMTestProxy getCurrentSuite() {
        if (this.getStackSize() != 0) {
            return this.myStack.peek();
        }
        return null;
    }

    @Nullable
    public SMTestProxy popSuite(String suiteName) throws EmptyStackException {
        if (this.myStack.isEmpty()) {
            if (SMTestRunnerConnectionUtil.isInDebugMode()) {
                LOG.error("Pop error: Tests/suites stack is empty. Test runner tried to close test suite which has been already closed or wasn't started at all. Unexpected suite name [" + suiteName + "]");
            }
            return null;
        }
        SMTestProxy topSuite = this.myStack.peek();
        if (!suiteName.equals(topSuite.getName())) {
            if (!SMTestRunnerConnectionUtil.isInDebugMode()) {
                SMTestProxy expectedProxy = null;
                for (SMTestProxy candidateProxy : this.myStack) {
                    if (!suiteName.equals(candidateProxy.getName())) continue;
                    expectedProxy = candidateProxy;
                    break;
                }
                if (expectedProxy != null) {
                    SMTestProxy proxy = topSuite;
                    while (proxy != expectedProxy) {
                        proxy = this.myStack.pop();
                    }
                    return expectedProxy;
                }
                return null;
            }
            LOG.error("Pop error: Unexpected closing suite. Expected [" + suiteName + "] but [" + topSuite.getName() + "] was found. Rest of stack: " + this.getSuitePathPresentation());
            return null;
        }
        this.myStack.pop();
        return topSuite;
    }

    public final boolean isEmpty() {
        return this.getStackSize() == 0;
    }

    protected int getStackSize() {
        return this.myStack.size();
    }

    protected String[] getSuitePath() {
        int stackSize = this.getStackSize();
        String[] names = new String[stackSize];
        for (int i = 0; i < stackSize; ++i) {
            names[i] = ((SMTestProxy)this.myStack.get(i)).getName();
        }
        return names;
    }

    protected String getSuitePathPresentation() {
        String[] names = this.getSuitePath();
        if (names.length == 0) {
            return EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        String lastName = names[names.length - 1];
        for (String name : names) {
            builder.append('[').append(name).append(']');
            if (name == lastName) continue;
            builder.append("->");
        }
        return builder.toString();
    }

    public void clear() {
        this.myStack.clear();
    }
}

