/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.ReadOnlyBlockContainer;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.ReadOnlyBlockInformationProvider;
import com.intellij.psi.impl.DebugUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class InitialInfoBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.formatting.InitialInfoBuilder");
    private WhiteSpace myCurrentWhiteSpace;
    private final FormattingDocumentModel myModel;
    private final FormatTextRanges myAffectedRanges;
    private final int myPositionOfInterest;
    private final Map<AbstractBlockWrapper, Block> myResult = new THashMap();
    private CompositeBlockWrapper myRootBlockWrapper;
    private LeafBlockWrapper myPreviousBlock;
    private LeafBlockWrapper myFirstTokenBlock;
    private LeafBlockWrapper myLastTokenBlock;
    private SpacingImpl myCurrentSpaceProperty;
    private final CodeStyleSettings.IndentOptions myOptions;
    private ReadOnlyBlockInformationProvider myReadOnlyBlockInformationProvider;

    private InitialInfoBuilder(FormattingDocumentModel model, FormatTextRanges affectedRanges, CodeStyleSettings.IndentOptions options, int positionOfInterest) {
        this.myModel = model;
        this.myAffectedRanges = affectedRanges;
        this.myCurrentWhiteSpace = new WhiteSpace(0, true);
        this.myOptions = options;
        this.myPositionOfInterest = positionOfInterest;
    }

    public static InitialInfoBuilder buildBlocks(Block root, FormattingDocumentModel model, FormatTextRanges affectedRanges, CodeStyleSettings.IndentOptions options, int interestingOffset) {
        InitialInfoBuilder builder = new InitialInfoBuilder(model, affectedRanges, options, interestingOffset);
        AbstractBlockWrapper wrapper = builder.buildFrom(root, 0, null, null, root.getTextRange(), null, true);
        wrapper.setIndent((IndentImpl)Indent.getNoneIndent());
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBlockWrapper buildFrom(Block rootBlock, int index, CompositeBlockWrapper parent, WrapImpl currentWrapParent, TextRange textRange, Block parentBlock, boolean rootBlockIsRightBlock) {
        WrapImpl wrap = (WrapImpl)rootBlock.getWrap();
        if (wrap != null) {
            wrap.registerParent(currentWrapParent);
            currentWrapParent = wrap;
        }
        int blockStartOffset = textRange.getStartOffset();
        if (parent != null) {
            if (textRange.getStartOffset() < parent.getStartOffset()) {
                InitialInfoBuilder.assertInvalidRanges(textRange.getStartOffset(), parent.getStartOffset(), this.myModel, "child block start is less than parent block start");
            }
            if (textRange.getEndOffset() > parent.getEndOffset()) {
                InitialInfoBuilder.assertInvalidRanges(textRange.getEndOffset(), parent.getEndOffset(), this.myModel, "child block end is after parent block end");
            }
        }
        this.myCurrentWhiteSpace.append(blockStartOffset, this.myModel, this.myOptions);
        boolean isReadOnly = this.isReadOnly(textRange, rootBlockIsRightBlock);
        ReadOnlyBlockInformationProvider previousProvider = this.myReadOnlyBlockInformationProvider;
        try {
            if (rootBlock instanceof ReadOnlyBlockInformationProvider) {
                this.myReadOnlyBlockInformationProvider = (ReadOnlyBlockInformationProvider)rootBlock;
            }
            if (isReadOnly) {
                AbstractBlockWrapper abstractBlockWrapper = this.processSimpleBlock(rootBlock, parent, isReadOnly, textRange, index, parentBlock);
                return abstractBlockWrapper;
            }
            List subBlocks = rootBlock.getSubBlocks();
            if (subBlocks.isEmpty() || this.myReadOnlyBlockInformationProvider != null && this.myReadOnlyBlockInformationProvider.isReadOnly(rootBlock)) {
                AbstractBlockWrapper wrapper = this.processSimpleBlock(rootBlock, parent, isReadOnly, textRange, index, parentBlock);
                if (!subBlocks.isEmpty()) {
                    wrapper.setIndent((IndentImpl)((Block)subBlocks.get(0)).getIndent());
                }
                AbstractBlockWrapper abstractBlockWrapper = wrapper;
                return abstractBlockWrapper;
            }
            AbstractBlockWrapper abstractBlockWrapper = this.processCompositeBlock(rootBlock, parent, textRange, index, subBlocks, currentWrapParent, rootBlockIsRightBlock);
            return abstractBlockWrapper;
        }
        finally {
            this.myReadOnlyBlockInformationProvider = previousProvider;
        }
    }

    private AbstractBlockWrapper processCompositeBlock(Block rootBlock, CompositeBlockWrapper parent, TextRange textRange, int index, List<Block> subBlocks, WrapImpl currentWrapParent, boolean rootBlockIsRightBlock) {
        CompositeBlockWrapper info = new CompositeBlockWrapper(rootBlock, this.myCurrentWhiteSpace, parent, textRange);
        if (index == 0) {
            info.arrangeParentTextRange();
        }
        if (this.myRootBlockWrapper == null) {
            this.myRootBlockWrapper = info;
        }
        boolean blocksMayBeOfInterest = false;
        if (this.myPositionOfInterest != -1) {
            this.myResult.put(info, rootBlock);
            blocksMayBeOfInterest = true;
        }
        Block previous = null;
        int subBlocksCount = subBlocks.size();
        ArrayList<AbstractBlockWrapper> list = new ArrayList<AbstractBlockWrapper>(subBlocksCount);
        boolean blocksAreReadOnly = rootBlock instanceof ReadOnlyBlockContainer || blocksMayBeOfInterest;
        for (int i = 0; i < subBlocksCount; ++i) {
            Block block = subBlocks.get(i);
            if (previous != null) {
                this.myCurrentSpaceProperty = (SpacingImpl)rootBlock.getSpacing(previous, block);
            }
            TextRange blockRange = block.getTextRange();
            boolean childBlockIsRightBlock = false;
            if (i == subBlocksCount - 1 && rootBlockIsRightBlock) {
                childBlockIsRightBlock = true;
            }
            AbstractBlockWrapper wrapper = this.buildFrom(block, i, info, currentWrapParent, blockRange, rootBlock, childBlockIsRightBlock);
            list.add(wrapper);
            if (wrapper.getIndent() == null) {
                wrapper.setIndent((IndentImpl)block.getIndent());
            }
            previous = block;
            if (blocksAreReadOnly) continue;
            subBlocks.set(i, null);
        }
        InitialInfoBuilder.setDefaultIndents(list);
        info.setChildren(list);
        return info;
    }

    private static void setDefaultIndents(List<AbstractBlockWrapper> list) {
        if (!list.isEmpty()) {
            for (AbstractBlockWrapper wrapper : list) {
                if (wrapper.getIndent() != null) continue;
                wrapper.setIndent((IndentImpl)Indent.getContinuationWithoutFirstIndent());
            }
        }
    }

    private AbstractBlockWrapper processSimpleBlock(Block rootBlock, CompositeBlockWrapper parent, boolean readOnly, TextRange textRange, int index, Block parentBlock) {
        LeafBlockWrapper info = new LeafBlockWrapper(rootBlock, parent, this.myCurrentWhiteSpace, this.myModel, this.myPreviousBlock, readOnly, textRange);
        if (index == 0) {
            info.arrangeParentTextRange();
        }
        if (textRange.getLength() == 0) {
            InitialInfoBuilder.assertInvalidRanges(textRange.getStartOffset(), textRange.getEndOffset(), this.myModel, "empty block");
        }
        if (this.myPreviousBlock != null) {
            this.myPreviousBlock.setNextBlock(info);
        }
        if (this.myFirstTokenBlock == null) {
            this.myFirstTokenBlock = info;
        }
        this.myLastTokenBlock = info;
        if (this.currentWhiteSpaceIsReadOnly()) {
            this.myCurrentWhiteSpace.setReadOnly(true);
        }
        if (this.myCurrentSpaceProperty != null) {
            this.myCurrentWhiteSpace.setIsSafe(this.myCurrentSpaceProperty.isSafe());
            this.myCurrentWhiteSpace.setKeepFirstColumn(this.myCurrentSpaceProperty.shouldKeepFirstColumn());
        }
        info.setSpaceProperty(this.myCurrentSpaceProperty);
        this.myCurrentWhiteSpace = new WhiteSpace(textRange.getEndOffset(), false);
        this.myPreviousBlock = info;
        if (this.myPositionOfInterest != -1 && (textRange.contains(this.myPositionOfInterest) || textRange.getEndOffset() == this.myPositionOfInterest)) {
            this.myResult.put(info, rootBlock);
            if (parent != null) {
                this.myResult.put(parent, parentBlock);
            }
        }
        return info;
    }

    private boolean currentWhiteSpaceIsReadOnly() {
        if (this.myCurrentSpaceProperty != null && this.myCurrentSpaceProperty.isReadOnly()) {
            return true;
        }
        if (this.myAffectedRanges == null) {
            return false;
        }
        boolean readOnly = this.myAffectedRanges.isWhitespaceReadOnly(this.myCurrentWhiteSpace.getTextRange());
        return readOnly;
    }

    private boolean isReadOnly(TextRange textRange, boolean rootIsRightBlock) {
        if (this.myAffectedRanges == null) {
            return false;
        }
        boolean readOnly = this.myAffectedRanges.isReadOnly(textRange, rootIsRightBlock);
        return readOnly;
    }

    public Map<AbstractBlockWrapper, Block> getBlockToInfoMap() {
        return this.myResult;
    }

    public CompositeBlockWrapper getRootBlockWrapper() {
        return this.myRootBlockWrapper;
    }

    public LeafBlockWrapper getFirstTokenBlock() {
        return this.myFirstTokenBlock;
    }

    public LeafBlockWrapper getLastTokenBlock() {
        return this.myLastTokenBlock;
    }

    public static void assertInvalidRanges(int startOffset, int newEndOffset, FormattingDocumentModel model, String message) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Invalid formatting blocks:").append(message).append("\n");
        buffer.append("Start offset:");
        buffer.append(startOffset);
        buffer.append(" end offset:");
        buffer.append(newEndOffset);
        buffer.append("\n");
        int minOffset = Math.max(Math.min(startOffset, newEndOffset) - 20, 0);
        int maxOffset = Math.min(Math.max(startOffset, newEndOffset) + 20, model.getTextLength());
        buffer.append("Affected text fragment:[").append(minOffset).append(",").append(maxOffset).append("] - '").append(model.getText(new TextRange(minOffset, maxOffset))).append("'\n");
        if (model instanceof FormattingDocumentModelImpl) {
            buffer.append("in ").append(((FormattingDocumentModelImpl)model).getFile().getLanguage()).append("\n");
        }
        buffer.append("File text:(" + model.getTextLength() + ")\n'");
        buffer.append(((Object)model.getText(new TextRange(0, model.getTextLength()))).toString());
        buffer.append("'\n");
        if (model instanceof FormattingDocumentModelImpl) {
            PsiFile[] roots;
            FormattingDocumentModelImpl modelImpl = (FormattingDocumentModelImpl)model;
            buffer.append("Psi Tree:\n");
            PsiFile file = modelImpl.getFile();
            for (PsiFile root : roots = file.getPsiRoots()) {
                buffer.append("Root ");
                DebugUtil.treeToBuffer(buffer, root.getNode(), 0, false, true, true);
            }
            buffer.append('\n');
        }
        LOG.error((Object)buffer);
    }
}

