/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.ContentFactory;
import com.intellij.history.core.LocalVcs;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class CacheUpdaterProcessor {
    private final LocalVcs myVcs;
    private final Set<VirtualFile> myFilesToCreate = new LinkedHashSet<VirtualFile>();
    private final Set<VirtualFile> myFilesToUpdate = new LinkedHashSet<VirtualFile>();

    public CacheUpdaterProcessor(LocalVcs vcs) {
        this.myVcs = vcs;
    }

    public void addFileToCreate(VirtualFile f) {
        this.myFilesToCreate.add(f);
    }

    public void addFileToUpdate(VirtualFile f) {
        this.myFilesToUpdate.add(f);
    }

    public VirtualFile[] queryNeededFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.myFilesToCreate);
        result.addAll(this.myFilesToUpdate);
        return VfsUtil.toVirtualFileArray(result);
    }

    public void processFile(FileContent c) {
        VirtualFile f = c.getVirtualFile();
        String path = f.getPath();
        if (this.myFilesToCreate.contains(f)) {
            if (this.myVcs.hasEntry(path)) {
                return;
            }
            this.myVcs.createFile(path, this.contentFactoryFor(c), c.getTimeStamp(), !c.isWritable());
        } else {
            this.myVcs.changeFileContent(path, this.contentFactoryFor(c), c.getTimeStamp());
        }
    }

    private ContentFactory contentFactoryFor(final FileContent c) {
        return new ContentFactory(){

            @Override
            public byte[] getBytes() throws IOException {
                return c.getBytes();
            }

            @Override
            public long getLength() throws IOException {
                return c.getLength();
            }
        };
    }
}

