/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.EntireFileDifferenceModel;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.openapi.vcs.changes.ContentRevision;

public class DirectoryChangeModel {
    private final Difference myDiff;
    private final IdeaGateway myGateway;
    private final boolean isRightContentEditable;

    public DirectoryChangeModel(Difference d, IdeaGateway gw, boolean editableRightContent) {
        this.myDiff = d;
        this.myGateway = gw;
        this.isRightContentEditable = editableRightContent;
    }

    public Difference getDifference() {
        return this.myDiff;
    }

    public boolean isFile() {
        return this.myDiff.isFile();
    }

    public String getEntryName(int i) {
        Entry e = this.getEntry(i);
        return e == null ? "" : e.getName();
    }

    public Entry getEntry(int i) {
        return i == 0 ? this.myDiff.getLeft() : this.myDiff.getRight();
    }

    public FileDifferenceModel getFileDifferenceModel() {
        return new EntireFileDifferenceModel(this.myGateway, this.myDiff.getLeft(), this.myDiff.getRight(), this.isRightContentEditable);
    }

    public boolean canShowFileDifference() {
        return this.isFile();
    }

    public ContentRevision getContentRevision(int i) {
        return i == 0 ? this.myDiff.getLeftContentRevision(this.myGateway) : this.myDiff.getRightContentRevision(this.myGateway);
    }
}

