/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferenceAction
extends AnAction {
    private static DataFlavor ourFlavor;

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        boolean enabled = CopyReferenceAction.isEnabled(dataContext);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
    }

    private static boolean isEnabled(DataContext dataContext) {
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        PsiElement element = CopyReferenceAction.getElementToCopy(editor, dataContext);
        return CopyReferenceAction.elementToFqn(element) != null;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        PsiElement element = CopyReferenceAction.getElementToCopy(editor, dataContext);
        if (!CopyReferenceAction.doCopy(element, project)) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (editor != null) {
            PsiElement toHighlight = HighlightUsagesHandler.getNameIdentifier(element);
            if (toHighlight == null) {
                toHighlight = element;
            }
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{toHighlight}, attributes, true, null);
        }
    }

    @Nullable
    private static PsiElement getElementToCopy(Editor editor, DataContext dataContext) {
        PsiReference reference;
        PsiElement element = null;
        if (editor != null && (reference = TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset())) != null) {
            element = reference.getElement();
        }
        if (element == null) {
            element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        if (element instanceof PsiFile && !((PsiFile)element).getViewProvider().isPhysical()) {
            return null;
        }
        for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
            PsiElement adjustedElement = provider.adjustElementToCopy(element);
            if (adjustedElement == null) continue;
            return adjustedElement;
        }
        return element;
    }

    public static boolean doCopy(PsiElement element, Project project) {
        String fqn = CopyReferenceAction.elementToFqn(element);
        if (fqn == null) {
            return false;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new MyTransferable(fqn));
        StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project);
        statusBar.setInfo(IdeBundle.message((String)"message.reference.to.fqn.has.been.copied", (Object[])new Object[]{fqn}));
        return true;
    }

    @Nullable
    static DataFlavor getFlavor() {
        if (ourFlavor != null) {
            return ourFlavor;
        }
        try {
            ourFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + MyTransferable.class.getName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return ourFlavor;
    }

    @Nullable
    private static String elementToFqn(PsiElement element) {
        for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
            String result = provider.getQualifiedName(element);
            if (result == null) continue;
            return result;
        }
        String fqn = null;
        if (element instanceof PsiFile) {
            PsiFile file = (PsiFile)element;
            fqn = FileUtil.toSystemIndependentName((String)CopyReferenceAction.getFileFqn(file));
        }
        return fqn;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String getFileFqn(PsiFile file) {
        String string;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            string = file.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CopyReferenceAction.getFileFqn must not return null");
            return string;
        }
        Project project = file.getProject();
        LogicalRoot logicalRoot = LogicalRootsManager.getLogicalRootsManager((Project)project).findLogicalRoot(virtualFile);
        if (logicalRoot != null) {
            String logical = FileUtil.toSystemIndependentName((String)VfsUtil.virtualToIoFile((VirtualFile)logicalRoot.getVirtualFile()).getPath());
            String path = FileUtil.toSystemIndependentName((String)VfsUtil.virtualToIoFile((VirtualFile)virtualFile).getPath());
            string = "/" + FileUtil.getRelativePath((String)logical, (String)path, (char)'/');
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CopyReferenceAction.getFileFqn must not return null");
            return string;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(virtualFile);
        if (contentRoot != null) {
            string = "/" + FileUtil.getRelativePath((File)VfsUtil.virtualToIoFile((VirtualFile)contentRoot), (File)VfsUtil.virtualToIoFile((VirtualFile)virtualFile));
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CopyReferenceAction.getFileFqn must not return null");
            return string;
        }
        string = virtualFile.getPath();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CopyReferenceAction.getFileFqn must not return null");
    }

    private static class MyTransferable
    implements Transferable {
        private final String fqn;

        public MyTransferable(String fqn) {
            this.fqn = fqn;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor flavor = CopyReferenceAction.getFlavor();
            if (flavor != null) {
                return new DataFlavor[]{flavor, DataFlavor.stringFlavor};
            }
            return new DataFlavor[]{DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(CopyReferenceAction.getFlavor()) || DataFlavor.stringFlavor.equals(flavor);
        }

        @Override
        @Nullable
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                return null;
            }
            return this.fqn;
        }
    }
}

