/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.Map;

public class GotoActionAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void gotoActionPerformed(final AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.action");
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup(project, new GotoActionModel(project, component), GotoActionAction.getPsiContext(e));
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
                if (GotoActionAction.class.equals((Object)GotoActionBase.myInAction)) {
                    GotoActionBase.myInAction = null;
                }
            }

            public void elementChosen(Object element) {
                final AnAction action = (AnAction)((Map.Entry)element).getKey();
                if (action != null) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AnActionEvent event = new AnActionEvent(e.getInputEvent(), DataManager.getInstance().getDataContext(component), e.getPlace(), (Presentation)action.getTemplatePresentation().clone(), ActionManager.getInstance(), e.getModifiers());
                            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)true)) {
                                action.actionPerformed(event);
                            }
                        }
                    }, ModalityState.NON_MODAL);
                }
            }
        }, ModalityState.current(), true);
    }
}

