/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;

public class SearchAgainAction
extends AnAction
implements DumbAware {
    public SearchAgainAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final FileEditor editor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
                if (FindManager.getInstance((Project)project).findNextUsageInEditor(editor)) {
                    return;
                }
                FindUtil.searchAgain(project, editor);
            }
        }, IdeBundle.message((String)"command.find.next", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        FileEditor editor = (FileEditor)event.getData(PlatformDataKeys.FILE_EDITOR);
        presentation.setEnabled(editor instanceof TextEditor);
    }
}

