/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.commander.AbstractListBuilder;
import com.intellij.ide.commander.CommanderHistoryListener;
import com.intellij.ide.commander.TopLevelNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListToolTipHandler;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RightAlignedLabelUI;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommanderPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.commander.CommanderPanel");
    private static final Color DARK_BLUE = new Color(55, 85, 134);
    private static final Color DARK_BLUE_BRIGHTER = new Color(58, 92, 149);
    private static final Color DARK_BLUE_DARKER = new Color(38, 64, 106);
    private Project myProject;
    private AbstractListBuilder myBuilder;
    private JPanel myTitlePanel;
    private JLabel myParentTitle;
    protected final JList myList;
    private final MyModel myModel;
    private CopyPasteDelegator myCopyPasteDelegator;
    protected final ListSpeedSearch myListSpeedSearch;
    private final IdeView myIdeView = new MyIdeView();
    private final MyDeleteElementProvider myDeleteElementProvider = new MyDeleteElementProvider();
    @NonNls
    private static final String ACTION_DRILL_DOWN = "DrillDown";
    @NonNls
    private static final String ACTION_GO_UP = "GoUp";
    private ProjectAbstractTreeStructureBase myProjectTreeStructure;
    private boolean myActive = true;
    private final List<CommanderHistoryListener> myHistoryListeners = ContainerUtil.createEmptyCOWList();
    private boolean myMoveFocus = false;

    public CommanderPanel(Project project, boolean enablePopupMenu) {
        super(new BorderLayout());
        this.myProject = project;
        this.myModel = new MyModel();
        this.myList = new JList(this.myModel);
        this.myList.setSelectionMode(2);
        if (enablePopupMenu) {
            this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this.myList){

                @Override
                @NotNull
                protected PsiElement[] getSelectedElements() {
                    PsiElement[] psiElementArray = CommanderPanel.this.getSelectedElements();
                    if (psiElementArray == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/ide/commander/CommanderPanel$1.getSelectedElements must not return null");
                    }
                    return psiElementArray;
                }
            };
        }
        this.myListSpeedSearch = new ListSpeedSearch(this.myList);
        ListScrollingUtil.installActions((JList)this.myList);
        this.myList.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CommanderPanel.this.myBuilder == null) {
                    return;
                }
                CommanderPanel.this.myBuilder.buildRoot();
            }
        }, KeyStroke.getKeyStroke(92, SystemInfo.isMac ? 4 : 2), 0);
        this.myList.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_DRILL_DOWN);
        this.myList.getInputMap(0).put(KeyStroke.getKeyStroke(34, SystemInfo.isMac ? 4 : 2), ACTION_DRILL_DOWN);
        this.myList.getActionMap().put(ACTION_DRILL_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommanderPanel.this.drillDown();
            }
        });
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CommanderPanel.this.drillDown();
                }
            }
        });
        this.myList.getInputMap(0).put(KeyStroke.getKeyStroke(33, SystemInfo.isMac ? 4 : 2), ACTION_GO_UP);
        this.myList.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), ACTION_GO_UP);
        this.myList.getActionMap().put(ACTION_GO_UP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommanderPanel.this.goUp();
            }
        });
        this.myList.getActionMap().put("selectAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        if (enablePopupMenu) {
            this.myList.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    CommanderPanel.this.invokePopup(comp, x, y);
                }
            });
        }
        this.myList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CommanderPanel.this.setActive(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                CommanderPanel.this.setActive(false);
            }
        });
        ListToolTipHandler.install(this.myList);
    }

    public void addHistoryListener(CommanderHistoryListener listener) {
        this.myHistoryListeners.add(listener);
    }

    public void removeHistoryListener(CommanderHistoryListener listener) {
        this.myHistoryListeners.remove(listener);
    }

    private void updateHistory(boolean elementExpanded) {
        for (CommanderHistoryListener listener : this.myHistoryListeners) {
            listener.historyChanged(this.getSelectedElement(), elementExpanded);
        }
    }

    public final JList getList() {
        return this.myList;
    }

    public final AbstractListBuilder.Model getModel() {
        return this.myModel;
    }

    public void setMoveFocus(boolean moveFocus) {
        this.myMoveFocus = moveFocus;
    }

    public void goUp() {
        if (this.myBuilder == null) {
            return;
        }
        this.updateHistory(true);
        this.myBuilder.goUp();
        this.updateHistory(false);
    }

    public void drillDown() {
        if (this.topElementIsSelected()) {
            this.goUp();
            return;
        }
        if (this.getSelectedValue() == null) {
            return;
        }
        AbstractTreeNode element = this.getSelectedNode();
        if (element.getChildren().size() == 0 && !this.shouldDrillDownOnEmptyElement(element)) {
            this.navigateSelectedElement();
            return;
        }
        if (this.myBuilder == null) {
            return;
        }
        this.updateHistory(false);
        this.myBuilder.drillDown();
        this.updateHistory(true);
    }

    public boolean navigateSelectedElement() {
        AbstractTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && selectedNode.canNavigateToSource()) {
            selectedNode.navigate(true);
            return true;
        }
        return false;
    }

    protected boolean shouldDrillDownOnEmptyElement(AbstractTreeNode node) {
        return node instanceof ProjectViewNode && ((ProjectViewNode)node).shouldDrillDownOnEmptyElement();
    }

    private boolean topElementIsSelected() {
        int[] selectedIndices = this.myList.getSelectedIndices();
        return selectedIndices.length == 1 && selectedIndices[0] == 0 && this.myModel.getElementAt(selectedIndices[0]) instanceof TopLevelNode;
    }

    public final void setBuilder(AbstractListBuilder builder) {
        this.myBuilder = builder;
        this.removeAll();
        this.myTitlePanel = new JPanel(new BorderLayout());
        this.myTitlePanel.setBackground(UIUtil.getControlColor());
        this.myTitlePanel.setOpaque(true);
        this.myParentTitle = new MyTitleLabel(this.myTitlePanel);
        this.myParentTitle.setText(" ");
        this.myParentTitle.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.myParentTitle.setForeground(Color.black);
        this.myParentTitle.setUI((LabelUI)new RightAlignedLabelUI());
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.setOpaque(false);
        panel1.add(Box.createHorizontalStrut(10), "West");
        panel1.add((Component)this.myParentTitle, "Center");
        this.myTitlePanel.add((Component)panel1, "Center");
        this.add((Component)this.myTitlePanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.myList);
        scrollPane.getVerticalScrollBar().setFocusable(false);
        scrollPane.getHorizontalScrollBar().setFocusable(false);
        this.add((Component)scrollPane, "Center");
        this.myBuilder.setParentTitle(this.myParentTitle);
        this.myTitlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommanderPanel.this.myList.requestFocus();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CommanderPanel.this.myList.requestFocus();
            }
        });
    }

    public final AbstractListBuilder getBuilder() {
        return this.myBuilder;
    }

    public final PsiElement getSelectedElement() {
        Object value = CommanderPanel.getValueAtIndex(this.getSelectedNode());
        return (PsiElement)(value instanceof PsiElement ? value : null);
    }

    public final PsiElement getSelectedElement(int index) {
        Object elementAtIndex = this.myModel.getElementAt(index);
        Object value = CommanderPanel.getValueAtIndex(elementAtIndex instanceof AbstractTreeNode ? (AbstractTreeNode)elementAtIndex : null);
        return (PsiElement)(value instanceof PsiElement ? value : null);
    }

    public AbstractTreeNode getSelectedNode() {
        if (this.myBuilder == null) {
            return null;
        }
        int[] indices = this.myList.getSelectedIndices();
        if (indices.length != 1) {
            return null;
        }
        int index = indices[0];
        if (index >= this.myModel.getSize()) {
            return null;
        }
        Object elementAtIndex = this.myModel.getElementAt(index);
        return elementAtIndex instanceof AbstractTreeNode ? (AbstractTreeNode)elementAtIndex : null;
    }

    private ArrayList<AbstractTreeNode> getSelectedNodes() {
        if (this.myBuilder == null) {
            return null;
        }
        int[] indices = this.myList.getSelectedIndices();
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (int index : indices) {
            AbstractTreeNode node;
            if (index >= this.myModel.getSize()) continue;
            Object elementAtIndex = this.myModel.getElementAt(index);
            AbstractTreeNode abstractTreeNode = node = elementAtIndex instanceof AbstractTreeNode ? (AbstractTreeNode)elementAtIndex : null;
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    public Object getSelectedValue() {
        return CommanderPanel.getValueAtIndex(this.getSelectedNode());
    }

    private PsiElement[] getSelectedElements() {
        if (this.myBuilder == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        int[] indices = this.myList.getSelectedIndices();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (int index : indices) {
            PsiElement element = this.getSelectedElement(index);
            if (element == null) continue;
            elements.add(element);
        }
        return elements.toArray(new PsiElement[elements.size()]);
    }

    private static Object getValueAtIndex(AbstractTreeNode node) {
        if (node == null) {
            return null;
        }
        Object value = node.getValue();
        if (value instanceof StructureViewTreeElement) {
            return ((StructureViewTreeElement)value).getValue();
        }
        return value;
    }

    public final void setActive(boolean active) {
        this.myActive = active;
        if (active) {
            this.myTitlePanel.setBackground(DARK_BLUE);
            this.myTitlePanel.setBorder(BorderFactory.createBevelBorder(0, DARK_BLUE_BRIGHTER, DARK_BLUE_DARKER));
            this.myParentTitle.setForeground(Color.white);
        } else {
            Color color = UIUtil.getPanelBackground();
            LOG.assertTrue(color != null);
            this.myTitlePanel.setBackground(color);
            this.myTitlePanel.setBorder(BorderFactory.createBevelBorder(1, color.brighter(), color.darker()));
            this.myParentTitle.setForeground(Color.black);
        }
        int[] selectedIndices = this.myList.getSelectedIndices();
        if (selectedIndices.length == 0 && this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndex(0);
            if (!this.myList.hasFocus()) {
                this.myList.requestFocus();
            }
        } else if (this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndices(selectedIndices);
        }
    }

    public boolean isActive() {
        return this.myActive;
    }

    private void invokePopup(Component c, int x, int y) {
        int popupIndex;
        if (this.myBuilder == null) {
            return;
        }
        if (this.myList.getSelectedIndices().length <= 1 && (popupIndex = this.myList.locationToIndex(new Point(x, y))) >= 0) {
            this.myList.setSelectedIndex(popupIndex);
            this.myList.requestFocus();
        }
        ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("CommanderPopupMenu");
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("CommanderPopup", group);
        popupMenu.getComponent().show(c, x, y);
    }

    public final void dispose() {
        if (this.myBuilder != null) {
            this.myBuilder.dispose();
            this.myBuilder = null;
        }
        this.myProject = null;
    }

    public final void setTitlePanelVisible(boolean flag) {
        this.myTitlePanel.setVisible(flag);
    }

    public final Object getDataImpl(String dataId) {
        if (this.myBuilder == null) {
            return null;
        }
        Object selectedValue = this.getSelectedValue();
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement selectedElement = this.getSelectedElement();
            return selectedElement != null && selectedElement.isValid() ? selectedElement : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return CommanderPanel.filterInvalidElements(this.getSelectedElements());
        }
        if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId)) {
            AbstractTreeNode parentNode = this.myBuilder.getParentNode();
            Object element = parentNode != null ? parentNode.getValue() : null;
            return element instanceof PsiElement && ((PsiElement)element).isValid() ? element : null;
        }
        if (PlatformDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getNavigatables();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator != null ? this.myCopyPasteDelegator.getCopyProvider() : null;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator != null ? this.myCopyPasteDelegator.getCutProvider() : null;
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator != null ? this.myCopyPasteDelegator.getPasteProvider() : null;
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteElementProvider;
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            return selectedValue instanceof Module ? selectedValue : null;
        }
        if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
            ModuleGroup[] moduleGroupArray;
            if (selectedValue instanceof ModuleGroup) {
                ModuleGroup[] moduleGroupArray2 = new ModuleGroup[1];
                moduleGroupArray = moduleGroupArray2;
                moduleGroupArray2[0] = (ModuleGroup)selectedValue;
            } else {
                moduleGroupArray = null;
            }
            return moduleGroupArray;
        }
        if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
            LibraryGroupElement[] libraryGroupElementArray;
            if (selectedValue instanceof LibraryGroupElement) {
                LibraryGroupElement[] libraryGroupElementArray2 = new LibraryGroupElement[1];
                libraryGroupElementArray = libraryGroupElementArray2;
                libraryGroupElementArray2[0] = (LibraryGroupElement)selectedValue;
            } else {
                libraryGroupElementArray = null;
            }
            return libraryGroupElementArray;
        }
        if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
            NamedLibraryElement[] namedLibraryElementArray;
            if (selectedValue instanceof NamedLibraryElement) {
                NamedLibraryElement[] namedLibraryElementArray2 = new NamedLibraryElement[1];
                namedLibraryElementArray = namedLibraryElementArray2;
                namedLibraryElementArray2[0] = (NamedLibraryElement)selectedValue;
            } else {
                namedLibraryElementArray = null;
            }
            return namedLibraryElementArray;
        }
        if (this.myProjectTreeStructure != null) {
            return this.myProjectTreeStructure.getDataFromProviders(this.getSelectedNodes(), dataId);
        }
        return null;
    }

    private Navigatable[] getNavigatables() {
        if (this.myBuilder == null) {
            return null;
        }
        int[] indices = this.myList.getSelectedIndices();
        if (indices == null || indices.length == 0) {
            return null;
        }
        ArrayList<Navigatable> elements = new ArrayList<Navigatable>();
        for (int index : indices) {
            Object element = this.myModel.getElementAt(index);
            if (!(element instanceof AbstractTreeNode)) continue;
            elements.add((Navigatable)element);
        }
        return elements.toArray(new Navigatable[elements.size()]);
    }

    @Nullable
    private static PsiElement[] filterInvalidElements(PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        ArrayList<PsiElement> validElements = new ArrayList<PsiElement>(elements.length);
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            validElements.add(element);
        }
        return validElements.size() == elements.length ? elements : validElements.toArray(new PsiElement[validElements.size()]);
    }

    protected final Navigatable createEditSourceDescriptor() {
        return EditSourceUtil.getDescriptor((PsiElement)this.getSelectedElement());
    }

    public void setProjectTreeStructure(ProjectAbstractTreeStructureBase projectTreeStructure) {
        this.myProjectTreeStructure = projectTreeStructure;
    }

    private static final class MyModel
    extends AbstractListBuilder.Model {
        final List myElements = new ArrayList();

        private MyModel() {
        }

        @Override
        public void removeAllElements() {
            int index1 = this.myElements.size() - 1;
            this.myElements.clear();
            if (index1 >= 0) {
                this.fireIntervalRemoved(this, 0, index1);
            }
        }

        @Override
        public void addElement(Object obj) {
            int index = this.myElements.size();
            this.myElements.add(obj);
            this.fireIntervalAdded(this, index, index);
        }

        @Override
        public void replaceElements(List newElements) {
            this.removeAllElements();
            this.myElements.addAll(newElements);
            this.fireIntervalAdded(this, 0, newElements.size());
        }

        @Override
        public Object[] toArray() {
            return ArrayUtil.toObjectArray((Collection)this.myElements);
        }

        @Override
        public int indexOf(Object o) {
            return this.myElements.indexOf(o);
        }

        @Override
        public int getSize() {
            return this.myElements.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.myElements.get(index);
        }
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(final PsiElement element) {
            final boolean isDirectory = element instanceof PsiDirectory;
            if (!isDirectory) {
                EditorHelper.openInEditor(element);
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommanderPanel.this.myBuilder.selectElement(element, PsiUtilBase.getVirtualFile((PsiElement)element));
                    if (!isDirectory) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (CommanderPanel.this.myMoveFocus) {
                                    ToolWindowManager.getInstance((Project)CommanderPanel.this.myProject).activateEditorComponent();
                                }
                            }
                        });
                    }
                }
            }, ModalityState.NON_MODAL);
        }

        private PsiDirectory getDirectory() {
            if (CommanderPanel.this.myBuilder == null) {
                return null;
            }
            AbstractTreeNode parentElement = CommanderPanel.this.myBuilder.getParentNode();
            if (parentElement instanceof AbstractTreeNode) {
                AbstractTreeNode parentNode = parentElement;
                if (!(parentNode.getValue() instanceof PsiDirectory)) {
                    return null;
                }
                return (PsiDirectory)parentNode.getValue();
            }
            return null;
        }

        public PsiDirectory[] getDirectories() {
            PsiDirectory[] psiDirectoryArray;
            PsiDirectory directory = this.getDirectory();
            if (directory == null) {
                psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
            } else {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = directory;
            }
            return psiDirectoryArray;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }

    private final class MyDeleteElementProvider
    implements DeleteProvider {
        private MyDeleteElementProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(DataContext dataContext) {
            LocalHistoryAction a = LocalHistory.startAction((Project)CommanderPanel.this.myProject, (String)IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                PsiElement[] elements = CommanderPanel.this.getSelectedElements();
                DeleteHandler.deletePsiElement(elements, CommanderPanel.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        public boolean canDeleteElement(DataContext dataContext) {
            PsiElement[] elements = CommanderPanel.this.getSelectedElements();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }
    }

    private static final class MyTitleLabel
    extends JLabel {
        private final JPanel myPanel;

        public MyTitleLabel(JPanel panel) {
            this.myPanel = panel;
        }

        @Override
        public void setText(String text) {
            if (text == null || text.length() == 0) {
                text = " ";
            }
            super.setText(text);
            if (this.myPanel != null) {
                this.myPanel.setToolTipText(text.trim().length() == 0 ? null : text);
            }
        }
    }
}

