/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;

public class FileTemplateImpl
implements FileTemplate,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateImpl");
    private String myDescription;
    private String myContent;
    private String myName;
    private String myExtension;
    private File myTemplateFile;
    private String myTemplateURL;
    private boolean myRenamed;
    private boolean myModified;
    private boolean myReadOnly;
    private boolean myAdjust;
    private boolean myIsInternal;

    FileTemplateImpl(@NotNull String content, @NotNull String name, @NotNull String extension) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        this.myRenamed = false;
        this.myModified = false;
        this.myReadOnly = false;
        this.myAdjust = true;
        this.myIsInternal = false;
        this.myContent = StringUtil.convertLineSeparators((String)content);
        this.myName = FileTemplateImpl.replaceFileSeparatorChar(name);
        this.myExtension = extension;
        this.myModified = true;
    }

    FileTemplateImpl(@NotNull File templateFile, @NotNull String name, @NotNull String extension, boolean isReadOnly) {
        if (templateFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        this.myRenamed = false;
        this.myModified = false;
        this.myReadOnly = false;
        this.myAdjust = true;
        this.myIsInternal = false;
        this.myTemplateFile = templateFile;
        this.myName = FileTemplateImpl.replaceFileSeparatorChar(name);
        this.myExtension = extension;
        this.myModified = false;
        this.myReadOnly = isReadOnly;
    }

    FileTemplateImpl(@NotNull VirtualFile templateURL, @NotNull String name, @NotNull String extension) {
        if (templateURL == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.<init> must not be null");
        }
        this.myRenamed = false;
        this.myModified = false;
        this.myReadOnly = false;
        this.myAdjust = true;
        this.myIsInternal = false;
        this.myTemplateURL = templateURL.getUrl();
        this.myName = name;
        this.myExtension = extension;
        this.myModified = false;
        this.myReadOnly = true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String[] getUnsetAttributes(@NotNull Properties properties) throws ParseException {
        String[] stringArray;
        String content;
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getUnsetAttributes must not be null");
        }
        try {
            content = this.getContent();
        }
        catch (IOException e) {
            LOG.error("Unable to read template \"" + this.myName + "\"", (Throwable)e);
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            if (ArrayUtil.EMPTY_STRING_ARRAY != null) return stringArray;
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getUnsetAttributes must not return null");
        }
        String[] stringArray2 = FileTemplateUtil.calculateAttributes(content, properties, false);
        stringArray = stringArray2;
        if (stringArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getUnsetAttributes must not return null");
        return stringArray;
    }

    @Override
    public synchronized boolean isDefault() {
        return this.myReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getDescription() {
        String description;
        block6: {
            try {
                FileTemplateImpl fileTemplateImpl = this;
                synchronized (fileTemplateImpl) {
                    description = this.myDescription;
                }
                if (description != null) break block6;
                return "";
            }
            catch (IOException e) {
                return "";
            }
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(description);
        LOG.assertTrue(virtualFile != null, (Object)("Unable to find description at '" + description + "'"));
        String string = VfsUtil.loadText((VirtualFile)virtualFile);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getDescription must not return null");
        return string2;
    }

    synchronized void setDescription(VirtualFile file) {
        this.myDescription = file.getUrl();
    }

    @Override
    @NotNull
    public synchronized String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getName must not return null");
        }
        return string;
    }

    @Override
    public synchronized boolean isJavaClassTemplate() {
        FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(this.myExtension);
        return fileType.equals(StdFileTypes.JAVA);
    }

    @Override
    @NotNull
    public synchronized String getExtension() {
        String string = this.myExtension;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getExtension must not return null");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getText() {
        String string;
        try {
            string = this.getContent();
        }
        catch (IOException e) {
            LOG.error("Unable to read template \"" + this.myName + "\"", (Throwable)e);
            return "";
        }
        String string2 = string;
        if (string != null) return string2;
        throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getText must not return null");
    }

    @Override
    public synchronized void setText(String text) {
        if (text == null) {
            text = "";
        }
        if ((text = StringUtil.convertLineSeparators((String)text)).equals(this.getText())) {
            return;
        }
        this.myContent = text;
        this.myModified = true;
        if (this.myReadOnly) {
            this.myTemplateFile = null;
            this.myTemplateURL = null;
            this.myReadOnly = false;
        }
    }

    synchronized boolean isModified() {
        return this.myModified;
    }

    private static String readExternal(File file) throws IOException {
        return new String(FileUtil.loadFileText((File)file, (String)"UTF-8"));
    }

    private static String readExternal(VirtualFile url) throws IOException {
        Document content = FileDocumentManager.getInstance().getDocument(url);
        return content != null ? content.getText() : new String(url.contentsToByteArray(), "UTF-8");
    }

    synchronized void removeFromDisk() {
        if (!this.myReadOnly && this.myTemplateFile != null && this.myTemplateFile.delete()) {
            this.myModified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeExternal(File defaultDir) throws IOException {
        OutputStreamWriter outputStreamWriter;
        File templateFile;
        FileTemplateImpl fileTemplateImpl = this;
        synchronized (fileTemplateImpl) {
            if (!this.myModified && !this.myRenamed) {
                return;
            }
            if (this.myRenamed) {
                LOG.assertTrue(this.myTemplateFile != null);
                LOG.assertTrue(this.myTemplateFile.delete());
                this.myTemplateFile = null;
                this.myRenamed = false;
            }
            File file = templateFile = this.myReadOnly ? null : this.myTemplateFile;
            if (templateFile == null) {
                LOG.assertTrue(defaultDir.isDirectory());
                templateFile = new File(defaultDir, this.myName + "." + this.myExtension);
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(templateFile);
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.unable.to.save.file.template.using.encoding", (Object[])new Object[]{this.getName(), "UTF-8"}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        }
        String content = this.getContent();
        Project project = ProjectManagerEx.getInstanceEx().getDefaultProject();
        String lineSeparator = CodeStyleSettingsManager.getSettings((Project)project).getLineSeparator();
        if (!lineSeparator.equals("\n")) {
            content = StringUtil.convertLineSeparators((String)content, (String)lineSeparator);
        }
        outputStreamWriter.write(content);
        outputStreamWriter.close();
        fileOutputStream.close();
        FileTemplateImpl fileTemplateImpl2 = this;
        synchronized (fileTemplateImpl2) {
            this.myModified = false;
            this.myTemplateFile = templateFile;
        }
    }

    @Override
    @NotNull
    public String getText(Map attributes) throws IOException {
        String string = StringUtil.convertLineSeparators((String)FileTemplateUtil.mergeTemplate(attributes, this.getContent()));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getText must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getText(Properties attributes) throws IOException {
        String string = StringUtil.convertLineSeparators((String)FileTemplateUtil.mergeTemplate(attributes, this.getContent()));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getText must not return null");
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String getContent() throws IOException {
        String templateURL;
        File templateIOFile;
        String content;
        FileTemplateImpl fileTemplateImpl = this;
        synchronized (fileTemplateImpl) {
            content = this.myContent;
            templateIOFile = this.myTemplateFile;
            templateURL = this.myTemplateURL;
        }
        if (content == null) {
            VirtualFile templateFile;
            content = templateIOFile != null ? StringUtil.convertLineSeparators((String)FileTemplateImpl.readExternal(templateIOFile)) : (templateURL != null ? ((templateFile = VirtualFileManager.getInstance().findFileByUrl(templateURL)) == null ? "" : StringUtil.convertLineSeparators((String)FileTemplateImpl.readExternal(templateFile))) : "");
            fileTemplateImpl = this;
            synchronized (fileTemplateImpl) {
                this.myContent = content;
            }
        }
        String string = content;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateImpl.getContent must not return null");
        }
        return string;
    }

    synchronized void invalidate() {
        if (!(this.myReadOnly || this.myTemplateFile == null && this.myTemplateURL == null)) {
            this.myContent = null;
        }
    }

    synchronized boolean isNew() {
        return this.myTemplateFile == null && this.myTemplateURL == null;
    }

    @Override
    public synchronized void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.setName must not be null");
        }
        if (!this.myName.equals(name = FileTemplateImpl.replaceFileSeparatorChar(name.trim()))) {
            LOG.assertTrue(!this.myReadOnly);
            this.myName = name;
            this.myRenamed = true;
            this.myModified = true;
        }
    }

    @Override
    public synchronized void setExtension(@NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateImpl.setExtension must not be null");
        }
        if (!this.myExtension.equals(extension = extension.trim())) {
            LOG.assertTrue(!this.myReadOnly);
            this.myExtension = extension;
            this.myRenamed = true;
            this.myModified = true;
        }
    }

    @Override
    public synchronized boolean isAdjust() {
        return this.myAdjust;
    }

    @Override
    public synchronized void setAdjust(boolean adjust) {
        this.myAdjust = adjust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToDefault() {
        String extension;
        String name;
        LOG.assertTrue(!this.isDefault());
        FileTemplateImpl fileTemplateImpl = this;
        synchronized (fileTemplateImpl) {
            name = this.myName;
            extension = this.myExtension;
        }
        VirtualFile file = FileTemplateManagerImpl.getInstanceImpl().getDefaultTemplate(name, extension);
        if (file == null) {
            return;
        }
        try {
            String text = FileTemplateImpl.readExternal(file);
            this.setText(text);
            FileTemplateImpl fileTemplateImpl2 = this;
            synchronized (fileTemplateImpl2) {
                this.myReadOnly = true;
            }
        }
        catch (IOException e) {
            LOG.error("Error reading template");
        }
    }

    private static String replaceFileSeparatorChar(String s) {
        char[] chars;
        StringBuilder buffer = new StringBuilder();
        for (char aChar : chars = s.toCharArray()) {
            if (aChar == File.separatorChar) {
                buffer.append("$");
                continue;
            }
            buffer.append(aChar);
        }
        return buffer.toString();
    }

    public synchronized void setInternal(boolean isInternal) {
        this.myIsInternal = isInternal;
    }

    @Override
    public synchronized boolean isInternal() {
        return this.myIsInternal;
    }

    synchronized void setModified(boolean modified) {
        this.myModified = modified;
    }

    synchronized void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }
}

