/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import java.awt.Color;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;

public final class HierarchyNodeRenderer
extends ColoredTreeCellRenderer {
    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node;
        Object object;
        if (value instanceof DefaultMutableTreeNode && (object = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof HierarchyNodeDescriptor) {
            Color color;
            HierarchyNodeDescriptor descriptor = (HierarchyNodeDescriptor)((Object)object);
            descriptor.getHighlightedText().customize((SimpleColoredComponent)this);
            if (expanded) {
                this.setIcon(descriptor.getOpenIcon());
            } else {
                this.setIcon(descriptor.getClosedIcon());
            }
            if (!selected && (color = HierarchyNodeRenderer.getBackgroundColor(descriptor)) != null) {
                this.setBackground(color);
            }
        }
    }

    @Nullable
    private static Color getBackgroundColor(HierarchyNodeDescriptor descriptor) {
        PsiFile psiFile = descriptor.getContainingFile();
        if (psiFile != null && psiFile.isValid()) {
            FileColorManager colorManager = FileColorManager.getInstance((Project)descriptor.getProject());
            return colorManager.getRendererBackground(psiFile);
        }
        return null;
    }
}

