/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public abstract class HierarchyTreeStructure
extends AbstractTreeStructure {
    protected HierarchyNodeDescriptor myBaseDescriptor;
    private HierarchyNodeDescriptor myRoot;
    protected final Project myProject;

    protected HierarchyTreeStructure(Project project, HierarchyNodeDescriptor baseDescriptor) {
        this.myBaseDescriptor = baseDescriptor;
        this.myProject = project;
        this.myRoot = this.myBaseDescriptor;
    }

    public final HierarchyNodeDescriptor getBaseDescriptor() {
        return this.myBaseDescriptor;
    }

    protected final void setBaseElement(HierarchyNodeDescriptor baseElement) {
        this.myRoot = this.myBaseDescriptor = baseElement;
        while (this.myRoot.getParentDescriptor() != null) {
            this.myRoot = (HierarchyNodeDescriptor)this.myRoot.getParentDescriptor();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        NodeDescriptor nodeDescriptor;
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor hierarchyNodeDescriptor = (HierarchyNodeDescriptor)((Object)element);
            nodeDescriptor = hierarchyNodeDescriptor;
            if (hierarchyNodeDescriptor != null) return nodeDescriptor;
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/HierarchyTreeStructure.createDescriptor must not return null");
        }
        if (element instanceof String) {
            TextInfoNodeDescriptor textInfoNodeDescriptor = new TextInfoNodeDescriptor(parentDescriptor, (String)element, this.myProject);
            nodeDescriptor = textInfoNodeDescriptor;
            if (textInfoNodeDescriptor == null) throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/HierarchyTreeStructure.createDescriptor must not return null");
            return nodeDescriptor;
        }
        nodeDescriptor = null;
        throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/HierarchyTreeStructure.createDescriptor must not return null");
    }

    public final boolean isToBuildChildrenInBackground(Object element) {
        HierarchyNodeDescriptor descriptor;
        Object[] cachedChildren;
        return element instanceof HierarchyNodeDescriptor && (cachedChildren = (descriptor = (HierarchyNodeDescriptor)((Object)element)).getCachedChildren()) == null && descriptor.isValid();
    }

    public final Object[] getChildElements(Object element) {
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor descriptor = (HierarchyNodeDescriptor)((Object)element);
            Object[] cachedChildren = descriptor.getCachedChildren();
            if (cachedChildren == null) {
                if (!descriptor.isValid()) {
                    descriptor.setCachedChildren(ArrayUtil.EMPTY_OBJECT_ARRAY);
                } else {
                    descriptor.setCachedChildren(this.buildChildren(descriptor));
                }
            }
            return descriptor.getCachedChildren();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public final Object getParentElement(Object element) {
        if (element instanceof HierarchyNodeDescriptor) {
            return ((HierarchyNodeDescriptor)((Object)element)).getParentDescriptor();
        }
        return null;
    }

    public final void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    public final boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    protected abstract Object[] buildChildren(HierarchyNodeDescriptor var1);

    public final Object getRootElement() {
        return this.myRoot;
    }

    protected SearchScope getSearchScope(String scopeType, PsiElement thisClass) {
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(scopeType)) {
            searchScope = new LocalSearchScope(thisClass);
        } else if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(scopeType)) {
            searchScope = GlobalSearchScope.projectProductionScope((Project)this.myProject);
        } else if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(scopeType)) {
            searchScope = GlobalSearchScope.projectTestScope((Project)this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)scopeType);
            if (namedScope != null) {
                searchScope = GlobalSearchScope.filterScope((Project)this.myProject, (NamedScope)namedScope);
            }
        }
        return searchScope;
    }

    protected boolean isInScope(PsiElement baseClass, PsiElement srcElement, String scopeType) {
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(scopeType)) {
            if (!PsiTreeUtil.isAncestor((PsiElement)baseClass, (PsiElement)srcElement, (boolean)true)) {
                return false;
            }
        } else if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(scopeType)) {
            VirtualFile virtualFile = srcElement.getContainingFile().getVirtualFile();
            if (virtualFile != null && ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInTestSourceContent(virtualFile)) {
                return false;
            }
        } else if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(scopeType)) {
            VirtualFile virtualFile = srcElement.getContainingFile().getVirtualFile();
            if (virtualFile != null && !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInTestSourceContent(virtualFile)) {
                return false;
            }
        } else if (!HierarchyBrowserBaseEx.SCOPE_ALL.equals(scopeType)) {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)scopeType);
            if (namedScope == null) {
                return false;
            }
            PackageSet namedScopePattern = namedScope.getValue();
            if (namedScopePattern == null) {
                return false;
            }
            PsiFile psiFile = srcElement.getContainingFile();
            if (psiFile != null && !namedScopePattern.contains(psiFile, NamedScopesHolder.getHolder((Project)this.myProject, (String)scopeType, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.myProject)))) {
                return false;
            }
        }
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    private static final class TextInfoNodeDescriptor
    extends NodeDescriptor {
        public TextInfoNodeDescriptor(NodeDescriptor parentDescriptor, String text, Project project) {
            super(project, parentDescriptor);
            this.myName = text;
            this.myColor = Color.red;
        }

        public final Object getElement() {
            return this.myName;
        }

        public final boolean update() {
            return true;
        }
    }
}

