/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.TreeViewUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageUtil {
    public static PsiPackage[] getSubpackages(PsiPackage aPackage, Module module, Project project, boolean searchInLibraries) {
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(project, module, searchInLibraries);
        PsiDirectory[] dirs = aPackage.getDirectories(scopeToShow);
        HashSet<PsiPackage> subpackages = new HashSet<PsiPackage>();
        for (PsiDirectory dir : dirs) {
            PsiDirectory[] subdirectories;
            for (PsiDirectory subdirectory : subdirectories = dir.getSubdirectories()) {
                String name;
                PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                if (psiPackage == null || (name = psiPackage.getName()) == null || "".equals(name)) continue;
                subpackages.add(psiPackage);
            }
        }
        return subpackages.toArray(new PsiPackage[subpackages.size()]);
    }

    public static void addPackageAsChild(Collection<AbstractTreeNode> children, PsiPackage aPackage, Module module, ViewSettings settings, boolean inLibrary) {
        boolean shouldSkipPackage = settings.isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, module, !settings.isFlattenPackages(), inLibrary);
        Project project = aPackage.getProject();
        if (!shouldSkipPackage) {
            children.add((AbstractTreeNode)new PackageElementNode(project, new PackageElement(module, aPackage, inLibrary), settings));
        }
        if (settings.isFlattenPackages() || shouldSkipPackage) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module, project, inLibrary)) {
                PackageUtil.addPackageAsChild(children, subpackage, module, settings, inLibrary);
            }
        }
    }

    public static boolean isPackageEmpty(PsiPackage aPackage, Module module, boolean strictlyEmpty, boolean inLibrary) {
        PsiDirectory[] dirs;
        Project project = aPackage.getProject();
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(project, module, inLibrary);
        for (PsiDirectory dir : dirs = aPackage.getDirectories(scopeToShow)) {
            if (TreeViewUtil.isEmptyMiddlePackage(dir, strictlyEmpty)) continue;
            return false;
        }
        return true;
    }

    public static GlobalSearchScope getScopeToShow(Project project, Module module, boolean forLibraries) {
        if (module != null) {
            if (forLibraries) {
                return new ModuleLibrariesSearchScope(module);
            }
            return GlobalSearchScope.moduleScope((Module)module);
        }
        if (forLibraries) {
            return new ProjectLibrariesSearchScope(project);
        }
        return GlobalSearchScope.projectScope((Project)project);
    }

    public static boolean isPackageDefault(PsiPackage directoryPackage) {
        String qName = directoryPackage.getQualifiedName();
        return qName.length() == 0;
    }

    public static Collection<AbstractTreeNode> createPackageViewChildrenOnFiles(List<VirtualFile> sourceRoots, Project project, ViewSettings settings, Module module, boolean inLibrary) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : sourceRoots) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children.addAll(ProjectViewDirectoryHelper.getInstance(project).getDirectoryChildren(directory, settings, false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage topLevelPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children, topLevelPackage, module, settings, inLibrary);
        }
        return children;
    }

    public static String getNodeName(ViewSettings settings, PsiPackage aPackage, PsiPackage parentPackageInTree, String defaultShortName, boolean isFQNameShown) {
        String name;
        if (isFQNameShown) {
            name = settings.isAbbreviatePackageNames() ? TreeViewUtil.calcAbbreviatedPackageFQName(aPackage) : aPackage.getQualifiedName();
        } else if (parentPackageInTree != null) {
            String parentPackageName;
            StringBuilder buf = new StringBuilder();
            buf.append(aPackage.getName());
            for (PsiPackage parentPackage = aPackage.getParentPackage(); parentPackage != null && !parentPackage.equals(parentPackageInTree) && (parentPackageName = parentPackage.getName()) != null && !"".equals(parentPackageName); parentPackage = parentPackage.getParentPackage()) {
                buf.insert(0, ".");
                buf.insert(0, parentPackageName);
            }
            name = buf.toString();
        } else {
            name = defaultShortName;
        }
        return name;
    }

    private static class ProjectLibrariesSearchScope
    extends GlobalSearchScope {
        public ProjectLibrariesSearchScope(Project project) {
            super(project);
        }

        private static Module[] getModules(Project project) {
            return ModuleManager.getInstance((Project)project).getModules();
        }

        public boolean contains(VirtualFile file) {
            Module[] modules;
            for (Module module : modules = ProjectLibrariesSearchScope.getModules(this.getProject())) {
                OrderEntry orderEntryForFile = ModuleRootManager.getInstance((Module)module).getFileIndex().getOrderEntryForFile(file);
                if (!(orderEntryForFile instanceof JdkOrderEntry) && !(orderEntryForFile instanceof LibraryOrderEntry)) continue;
                return true;
            }
            return false;
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            Module[] modules;
            for (Module module : modules = ProjectLibrariesSearchScope.getModules(this.getProject())) {
                ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
                OrderEntry orderEntry1 = fileIndex.getOrderEntryForFile(file1);
                if (orderEntry1 == null) continue;
                OrderEntry orderEntry2 = fileIndex.getOrderEntryForFile(file2);
                if (orderEntry2 != null) {
                    return orderEntry2.compareTo((Object)orderEntry1);
                }
                return 0;
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope.isSearchInModuleContent must not be null");
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }

    private static class ModuleLibrariesSearchScope
    extends GlobalSearchScope {
        private final Module myModule;

        public ModuleLibrariesSearchScope(Module module) {
            super(module.getProject());
            this.myModule = module;
        }

        public boolean contains(VirtualFile file) {
            OrderEntry orderEntry = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
            return Comparing.compare((Comparable)fileIndex.getOrderEntryForFile(file2), (Comparable)fileIndex.getOrderEntryForFile(file1));
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope.isSearchInModuleContent must not be null");
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

