/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IconProvider;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import com.intellij.util.PathUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiDirectoryNode
extends BasePsiNode<PsiDirectory> {
    public PsiDirectoryNode(Project project, PsiDirectory value, ViewSettings viewSettings) {
        super(project, value, viewSettings);
    }

    @Override
    protected void updateImpl(PresentationData data) {
        String name;
        Project project = this.getProject();
        PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
        VirtualFile directoryFile = psiDirectory.getVirtualFile();
        Object parentValue = this.getParentValue();
        if (ProjectRootsUtil.isModuleContentRoot(directoryFile, project)) {
            ProjectFileIndex fi = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Module module = fi.getModuleForFile(directoryFile);
            data.setPresentableText(directoryFile.getName());
            if (module != null) {
                if (!(parentValue instanceof Module)) {
                    if (Comparing.equal((String)module.getName(), (String)directoryFile.getName())) {
                        data.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        data.addText(directoryFile.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        data.addText("[" + module.getName() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                } else {
                    data.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                if (parentValue instanceof Project || parentValue instanceof Module) {
                    data.addText(" (" + directoryFile.getPresentableUrl() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else if (ProjectRootsUtil.isSourceOrTestRoot(directoryFile, project)) {
                    if (ProjectRootsUtil.isInTestSource(directoryFile, project)) {
                        data.addText(" (test source root)", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    } else {
                        data.addText(" (source root)", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
                this.setupIcon(data, psiDirectory);
                return;
            }
        }
        String string = name = parentValue instanceof Project ? psiDirectory.getVirtualFile().getPresentableUrl() : ProjectViewDirectoryHelper.getInstance(psiDirectory.getProject()).getNodeName(this.getSettings(), parentValue, psiDirectory);
        if (name == null) {
            this.setValue(null);
            return;
        }
        data.setPresentableText(name);
        if (ProjectRootsUtil.isLibraryRoot(directoryFile, project)) {
            data.setLocationString("library home");
        } else {
            data.setLocationString(ProjectViewDirectoryHelper.getInstance(project).getLocationString(psiDirectory));
        }
        this.setupIcon(data, psiDirectory);
    }

    private void setupIcon(PresentationData data, PsiDirectory psiDirectory) {
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        for (IconProvider provider : (IconProvider[])Extensions.getExtensions((ExtensionPointName)IconProvider.EXTENSION_POINT_NAME)) {
            Icon closedIcon;
            Icon openIcon = provider.getIcon((PsiElement)psiDirectory, 4);
            if (openIcon == null || (closedIcon = provider.getIcon((PsiElement)psiDirectory, 8)) == null) continue;
            data.setOpenIcon(this.patchIcon(openIcon, virtualFile));
            data.setClosedIcon(this.patchIcon(closedIcon, virtualFile));
            return;
        }
    }

    @Override
    public Collection<AbstractTreeNode> getChildrenImpl() {
        return ProjectViewDirectoryHelper.getInstance(this.myProject).getDirectoryChildren((PsiDirectory)this.getValue(), this.getSettings(), true);
    }

    public String getTestPresentation() {
        return "PsiDirectory: " + ((PsiDirectory)this.getValue()).getName();
    }

    public boolean isFQNameShown() {
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).isShowFQName(this.getSettings(), this.getParentValue(), (PsiDirectory)this.getValue());
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/PsiDirectoryNode.contains must not be null");
        }
        PsiDirectory value = (PsiDirectory)this.getValue();
        if (value == null) {
            return false;
        }
        VirtualFile directory = value.getVirtualFile();
        if (directory.getFileSystem() instanceof LocalFileSystem) {
            file = PathUtil.getLocalFile((VirtualFile)file);
        }
        if (!VfsUtil.isAncestor((VirtualFile)directory, (VirtualFile)file, (boolean)false)) {
            return false;
        }
        Project project = value.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return !fileIndex.isIgnored(file);
    }

    public VirtualFile getVirtualFile() {
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory == null) {
            return null;
        }
        return directory.getVirtualFile();
    }

    public boolean canRepresent(Object element) {
        if (super.canRepresent(element)) {
            return true;
        }
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory == null) {
            return false;
        }
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).canRepresent(element, directory);
    }

    @Override
    public boolean canNavigate() {
        VirtualFile file = this.getVirtualFile();
        Project project = this.getProject();
        return file != null && (ProjectRootsUtil.isModuleContentRoot(file, project) || ProjectRootsUtil.isSourceOrTestRoot(file, project) || ProjectRootsUtil.isLibraryRoot(file, project));
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)this.getValue()));
        if (module != null) {
            if (ProjectRootsUtil.isModuleContentRoot(this.getVirtualFile(), this.getProject())) {
                ProjectSettingsService.getInstance(this.myProject).openModuleSettings(module);
            } else {
                ProjectSettingsService.getInstance(this.myProject).openContentEntriesSettings(module);
            }
        }
    }

    public int getWeight() {
        return this.isFQNameShown() ? 70 : 0;
    }

    public String getTitle() {
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory != null) {
            return PsiDirectoryFactory.getInstance(this.getProject()).getQualifiedName(directory, true);
        }
        return super.getTitle();
    }

    private Icon patchIcon(Icon original, VirtualFile file) {
        Bookmark bookmarkAtFile = BookmarkManager.getInstance(this.myProject).findFileBookmark(file);
        if (bookmarkAtFile != null) {
            RowIcon composite = new RowIcon(2);
            composite.setIcon(original, 0);
            composite.setIcon(bookmarkAtFile.getIcon(), 1);
            return PsiDirectoryNode.addReadMark((Icon)composite, file.isWritable());
        }
        return PsiDirectoryNode.addReadMark(original, file.isWritable());
    }

    private static Icon addReadMark(Icon originalIcon, boolean isWritable) {
        if (isWritable) {
            return originalIcon;
        }
        return LayeredIcon.create((Icon)originalIcon, (Icon)Icons.LOCKED_ICON);
    }

    public String getQualifiedNameSortKey() {
        PsiDirectoryFactory factory = PsiDirectoryFactory.getInstance(this.getProject());
        return factory.getQualifiedName((PsiDirectory)this.getValue(), true);
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 3;
    }

    public boolean shouldDrillDownOnEmptyElement() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }
}

