/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView.nodes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class BasePsiNode<T extends PsiElement>
extends PackageDependenciesNode {
    private SmartPsiElementPointer myPsiElementPointer = null;
    private PsiFile myFile = null;

    public BasePsiNode(T element) {
        if (element.isValid()) {
            this.myPsiElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createLazyPointer(element);
            this.myFile = element.getContainingFile();
        }
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        if (this.myPsiElementPointer == null) {
            return null;
        }
        PsiElement element = this.myPsiElementPointer.getElement();
        return element != null && element.isValid() ? element : null;
    }

    @Override
    public Icon getOpenIcon() {
        return this.getIcon();
    }

    @Override
    public Icon getClosedIcon() {
        return this.getIcon();
    }

    private Icon getIcon() {
        PsiElement element = this.getPsiElement();
        return element != null && element.isValid() ? element.getIcon(3) : null;
    }

    @Override
    public FileStatus getStatus() {
        if (this.myFile == null) {
            return FileStatus.NOT_CHANGED;
        }
        return FileStatusManager.getInstance((Project)this.myFile.getProject()).getStatus(this.myFile.getVirtualFile());
    }

    @Override
    public int getWeight() {
        return 4;
    }

    @Override
    public int getContainingFiles() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasePsiNode)) {
            return false;
        }
        BasePsiNode methodNode = (BasePsiNode)o;
        return Comparing.equal((Object)this.getPsiElement(), (Object)methodNode.getPsiElement());
    }

    public int hashCode() {
        PsiElement psiElement = this.getPsiElement();
        return psiElement == null ? 0 : psiElement.hashCode();
    }

    public PsiFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public boolean isValid() {
        PsiElement element = this.getPsiElement();
        return element != null && element.isValid();
    }

    public boolean isDeprecated() {
        return false;
    }
}

