/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class NavigationItemListCellRenderer
extends JPanel
implements ListCellRenderer {
    public NavigationItemListCellRenderer() {
        super(new BorderLayout());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Font editorFont = new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize());
        this.setFont(editorFont);
        this.removeAll();
        Component leftCellRendererComponent = new LeftRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Color listBg = leftCellRendererComponent.getBackground();
        this.add(leftCellRendererComponent, "West");
        if (UISettings.getInstance().SHOW_ICONS_IN_QUICK_NAVIGATION) {
            DefaultListCellRenderer moduleRenderer = ModuleRendererFactory.getInstance().getModuleRenderer();
            Component rightCellRendererComponent = moduleRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            rightCellRendererComponent.setBackground(listBg);
            this.add(rightCellRendererComponent, "East");
            JPanel spacer = new JPanel();
            Dimension size = rightCellRendererComponent.getSize();
            spacer.setSize(new Dimension((int)((double)size.width * 0.015 + (double)leftCellRendererComponent.getSize().width * 0.015), size.height));
            spacer.setBackground(isSelected ? UIUtil.getListSelectionBackground() : listBg);
            this.add((Component)spacer, "Center");
        }
        this.setBackground(isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
        return this;
    }

    private static class LeftRenderer
    extends ColoredListCellRenderer {
        private LeftRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            Color bgColor = UIUtil.getListBackground();
            if (value instanceof NavigationItem) {
                FileStatus status;
                boolean isProblemFile;
                NavigationItem element = (NavigationItem)value;
                ItemPresentation presentation = element.getPresentation();
                assert (presentation != null) : "PSI elements displayed in choose by name lists must return a non-null value from getPresentation(): element " + element.toString() + ", class " + element.getClass().getName();
                String name = presentation.getPresentableText();
                Color color = list.getForeground();
                boolean bl = isProblemFile = element instanceof PsiElement && WolfTheProblemSolver.getInstance((Project)((PsiElement)element).getProject()).isProblemFile(PsiUtilBase.getVirtualFile((PsiElement)((PsiElement)element)));
                if (element instanceof PsiElement || element instanceof DataProvider) {
                    PsiElement psiElement;
                    PsiElement psiElement2 = psiElement = element instanceof PsiElement ? (PsiElement)element : (PsiElement)LangDataKeys.PSI_ELEMENT.getData((DataProvider)element);
                    if (psiElement != null) {
                        Project project = psiElement.getProject();
                        VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)psiElement);
                        isProblemFile = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(virtualFile);
                        FileColorManager fileColorManager = FileColorManager.getInstance((Project)project);
                        Color fileColor = fileColorManager.getRendererBackground(psiElement.getContainingFile());
                        if (fileColor != null) {
                            bgColor = fileColor;
                        }
                    }
                }
                if ((status = element.getFileStatus()) != FileStatus.NOT_CHANGED) {
                    color = status.getColor();
                }
                TextAttributes textAttributes = NodeRenderer.getSimpleTextAttributes((ItemPresentation)presentation).toTextAttributes();
                if (isProblemFile) {
                    textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                    textAttributes.setEffectColor(Color.red);
                }
                textAttributes.setForegroundColor(color);
                SimpleTextAttributes nameAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
                this.append(name, nameAttributes);
                this.setIcon(presentation.getIcon(false));
                String containerText = presentation.getLocationString();
                if (containerText != null && containerText.length() > 0) {
                    this.append(" " + containerText, new SimpleTextAttributes(0, Color.GRAY));
                }
            } else {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append(value == null ? "" : value.toString(), new SimpleTextAttributes(0, list.getForeground()));
            }
            this.setPaintFocusBorder(false);
            this.setBackground(selected ? UIUtil.getListSelectionBackground() : bgColor);
        }
    }
}

