/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.impl.ProjectRootUtil;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.util.ActionRunner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.util.PackageUtil");

    @Nullable
    public static PsiDirectory findPossiblePackageDirectoryInModule(Module module, String packageName) {
        PsiDirectory[] psiDirectories;
        PsiPackage rootPackage;
        PsiDirectory psiDirectory = null;
        if (!"".equals(packageName) && (rootPackage = PackageUtil.findLongestExistingPackage(module.getProject(), packageName)) != null && (psiDirectories = PackageUtil.getPackageDirectoriesInModule(rootPackage, module)).length > 0) {
            psiDirectory = psiDirectories[0];
        }
        if (psiDirectory == null && PackageUtil.checkSourceRootsConfigured(module)) {
            VirtualFile[] sourceRoots;
            for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
                PsiDirectory directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(sourceRoot);
                if (directory == null) continue;
                psiDirectory = directory;
                break;
            }
        }
        return psiDirectory;
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(Project project, String packageName, PsiDirectory baseDir, boolean askUserToCreate) throws IncorrectOperationException {
        PsiDirectory[] sourceDirectories;
        PsiPackage rootPackage;
        PsiDirectory psiDirectory = null;
        if (!"".equals(packageName) && (rootPackage = PackageUtil.findLongestExistingPackage(project, packageName)) != null) {
            int beginIndex = rootPackage.getQualifiedName().length() + 1;
            packageName = beginIndex < packageName.length() ? packageName.substring(beginIndex) : "";
            String postfixToShow = packageName.replace('.', File.separatorChar);
            if (packageName.length() > 0) {
                postfixToShow = File.separatorChar + postfixToShow;
            }
            if ((psiDirectory = DirectoryChooserUtil.selectDirectory(project, rootPackage.getDirectories(), baseDir, postfixToShow)) == null) {
                return null;
            }
        }
        if (psiDirectory == null && (psiDirectory = DirectoryChooserUtil.selectDirectory(project, sourceDirectories = ProjectRootUtil.getRootDirectories(project, OrderRootType.SOURCES), baseDir, File.separatorChar + packageName.replace('.', File.separatorChar))) == null) {
            return null;
        }
        String restOfName = packageName;
        boolean askedToCreate = false;
        while (restOfName.length() > 0) {
            String name = PackageUtil.getLeftPart(restOfName);
            PsiDirectory foundExistingDirectory = psiDirectory.findSubdirectory(name);
            if (foundExistingDirectory == null) {
                if (!askedToCreate && askUserToCreate) {
                    int toCreate = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"prompt.create.non.existing.package", (Object[])new Object[]{packageName}), (String)IdeBundle.message((String)"title.package.not.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (toCreate != 0) {
                        return null;
                    }
                    askedToCreate = true;
                }
                psiDirectory = PackageUtil.createSubdirectory(psiDirectory, name, project);
            } else {
                psiDirectory = foundExistingDirectory;
            }
            restOfName = PackageUtil.cutLeftPart(restOfName);
        }
        return psiDirectory;
    }

    private static PsiDirectory createSubdirectory(final PsiDirectory oldDirectory, final String name, Project project) throws IncorrectOperationException {
        final PsiDirectory[] psiDirectory = new PsiDirectory[1];
        final IncorrectOperationException[] exception = new IncorrectOperationException[1];
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                psiDirectory[0] = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                    public PsiDirectory compute() {
                        try {
                            return oldDirectory.createSubdirectory(name);
                        }
                        catch (IncorrectOperationException e) {
                            exception[0] = e;
                            return null;
                        }
                    }
                });
            }
        }, IdeBundle.message((String)"command.create.new.subdirectory", (Object[])new Object[0]), null);
        if (exception[0] != null) {
            throw exception[0];
        }
        return psiDirectory[0];
    }

    public static PsiDirectory findOrCreateDirectoryForPackage(@NotNull Module module, String packageName, PsiDirectory baseDir, boolean askUserToCreate) throws IncorrectOperationException {
        PsiPackage rootPackage;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/PackageUtil.findOrCreateDirectoryForPackage must not be null");
        }
        Project project = module.getProject();
        PsiDirectory psiDirectory = null;
        if (!"".equals(packageName) && (rootPackage = PackageUtil.findLongestExistingPackage(module, packageName)) != null) {
            PsiDirectory[] moduleDirectories;
            int beginIndex = rootPackage.getQualifiedName().length() + 1;
            packageName = beginIndex < packageName.length() ? packageName.substring(beginIndex) : "";
            String postfixToShow = packageName.replace('.', File.separatorChar);
            if (packageName.length() > 0) {
                postfixToShow = File.separatorChar + postfixToShow;
            }
            if ((psiDirectory = DirectoryChooserUtil.selectDirectory(project, moduleDirectories = PackageUtil.getPackageDirectoriesInModule(rootPackage, module), baseDir, postfixToShow)) == null) {
                return null;
            }
        }
        if (psiDirectory == null) {
            if (!PackageUtil.checkSourceRootsConfigured(module)) {
                return null;
            }
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            ArrayList<PsiDirectory> directoryList = new ArrayList<PsiDirectory>();
            for (VirtualFile sourceRoot : sourceRoots) {
                PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
                if (directory == null) continue;
                directoryList.add(directory);
            }
            PsiDirectory[] sourceDirectories = directoryList.toArray(new PsiDirectory[directoryList.size()]);
            psiDirectory = DirectoryChooserUtil.selectDirectory(project, sourceDirectories, baseDir, File.separatorChar + packageName.replace('.', File.separatorChar));
            if (psiDirectory == null) {
                return null;
            }
        }
        String restOfName = packageName;
        boolean askedToCreate = false;
        while (restOfName.length() > 0) {
            final String name = PackageUtil.getLeftPart(restOfName);
            PsiDirectory foundExistingDirectory = psiDirectory.findSubdirectory(name);
            if (foundExistingDirectory == null) {
                if (!askedToCreate && askUserToCreate) {
                    int toCreate;
                    if (!ApplicationManager.getApplication().isUnitTestMode() && (toCreate = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"prompt.create.non.existing.package", (Object[])new Object[]{packageName}), (String)IdeBundle.message((String)"title.package.not.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                        return null;
                    }
                    askedToCreate = true;
                }
                final PsiDirectory psiDirectory1 = psiDirectory;
                try {
                    psiDirectory = (PsiDirectory)ActionRunner.runInsideWriteAction((ActionRunner.InterruptibleRunnableWithResult)new ActionRunner.InterruptibleRunnableWithResult<PsiDirectory>(){

                        public PsiDirectory run() throws Exception {
                            return psiDirectory1.createSubdirectory(name);
                        }
                    });
                }
                catch (IncorrectOperationException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new IncorrectOperationException(e.toString(), (Exception)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            } else {
                psiDirectory = foundExistingDirectory;
            }
            restOfName = PackageUtil.cutLeftPart(restOfName);
        }
        return psiDirectory;
    }

    private static PsiDirectory[] getPackageDirectoriesInModule(PsiPackage rootPackage, Module module) {
        final PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        String packageName = rootPackage.getQualifiedName();
        final ArrayList moduleDirectoryList = new ArrayList();
        ModulePackageIndex.getInstance((Module)module).getDirsByPackageName(packageName, false).forEach((Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile directory) {
                moduleDirectoryList.add(manager.findDirectory(directory));
                return true;
            }
        });
        return moduleDirectoryList.toArray(new PsiDirectory[moduleDirectoryList.size()]);
    }

    private static PsiPackage findLongestExistingPackage(Project project, String packageName) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        String nameToMatch = packageName;
        while (true) {
            PsiPackage aPackage;
            if ((aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(nameToMatch)) != null && PackageUtil.isWritablePackage(aPackage)) {
                return aPackage;
            }
            int lastDotIndex = nameToMatch.lastIndexOf(46);
            if (lastDotIndex < 0) break;
            nameToMatch = nameToMatch.substring(0, lastDotIndex);
        }
        return null;
    }

    private static boolean isWritablePackage(PsiPackage aPackage) {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            if (!directory.isValid() || !directory.isWritable()) continue;
            return true;
        }
        return false;
    }

    private static PsiDirectory getWritableDirectory(Query<VirtualFile> vFiles, PsiManager manager) {
        for (VirtualFile vFile : vFiles) {
            PsiDirectory directory = manager.findDirectory(vFile);
            if (directory == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    private static PsiPackage findLongestExistingPackage(Module module, String packageName) {
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        String nameToMatch = packageName;
        while (true) {
            Query vFiles;
            PsiDirectory directory;
            if ((directory = PackageUtil.getWritableDirectory((Query<VirtualFile>)(vFiles = ModulePackageIndex.getInstance((Module)module).getDirsByPackageName(nameToMatch, false)), manager)) != null) {
                return JavaDirectoryService.getInstance().getPackage(directory);
            }
            int lastDotIndex = nameToMatch.lastIndexOf(46);
            if (lastDotIndex < 0) break;
            nameToMatch = nameToMatch.substring(0, lastDotIndex);
        }
        return null;
    }

    private static String getLeftPart(String packageName) {
        int index = packageName.indexOf(46);
        return index > -1 ? packageName.substring(0, index) : packageName;
    }

    private static String cutLeftPart(String packageName) {
        int index = packageName.indexOf(46);
        return index > -1 ? packageName.substring(index + 1) : "";
    }

    public static boolean checkSourceRootsConfigured(Module module) {
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (sourceRoots.length == 0) {
            Messages.showErrorDialog((Project)module.getProject(), (String)ProjectBundle.message((String)"module.source.roots.not.configured.error", (Object[])new Object[]{module.getName()}), (String)ProjectBundle.message((String)"module.source.roots.not.configured.title", (Object[])new Object[0]));
            ProjectSettingsService.getInstance(module.getProject()).showModuleConfigurationDialog(module.getName(), CommonContentEntriesEditor.NAME, false);
            sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            if (sourceRoots.length == 0) {
                return false;
            }
        }
        return true;
    }
}

