/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.ListCellRenderer;

public abstract class ContributorsBasedGotoByModel
implements ChooseByNameModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel");
    protected final Project myProject;
    private final ChooseByNameContributor[] myContributors;

    protected ContributorsBasedGotoByModel(Project project, ChooseByNameContributor[] contributors) {
        this.myProject = project;
        this.myContributors = contributors;
    }

    public ListCellRenderer getListCellRenderer() {
        return new NavigationItemListCellRenderer();
    }

    public String[] getNames(boolean checkBoxState) {
        HashSet<String> names = new HashSet<String>();
        for (ChooseByNameContributor contributor : this.myContributors) {
            try {
                names.addAll(Arrays.asList(contributor.getNames(this.myProject, checkBoxState)));
            }
            catch (ProcessCanceledException ex) {
            }
            catch (IndexNotReadyException ex) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return ArrayUtil.toStringArray(names);
    }

    public Object[] getElementsByName(String name, boolean checkBoxState, String pattern) {
        ArrayList<NavigationItem> items = null;
        boolean dumb = DumbService.getInstance((Project)this.myProject).isDumb();
        for (ChooseByNameContributor contributor : this.myContributors) {
            try {
                if (dumb && !(contributor instanceof DumbAware)) continue;
                for (NavigationItem item : contributor.getItemsByName(name, pattern, this.myProject, checkBoxState)) {
                    if (!this.acceptItem(item)) continue;
                    if (items == null) {
                        items = new ArrayList<NavigationItem>(2);
                    }
                    items.add(item);
                }
            }
            catch (ProcessCanceledException ex) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        return items == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : ArrayUtil.toObjectArray(items);
    }

    public String getElementName(Object element) {
        return ((NavigationItem)element).getName();
    }

    public String getHelpId() {
        return null;
    }

    protected ChooseByNameContributor[] getContributors() {
        return this.myContributors;
    }

    protected boolean acceptItem(NavigationItem item) {
        return true;
    }
}

