/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.refactoring.DefaultRefactoringSupportProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandler;
import com.intellij.refactoring.memberPushDown.JavaPushDownHandler;
import org.jetbrains.annotations.Nullable;

public class JavaRefactoringSupportProvider
extends DefaultRefactoringSupportProvider {
    public boolean isSafeDeleteAvailable(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod || element instanceof PsiPackage;
    }

    public RefactoringActionHandler getIntroduceConstantHandler() {
        return new IntroduceConstantHandler();
    }

    public RefactoringActionHandler getIntroduceFieldHandler() {
        return new IntroduceFieldHandler();
    }

    public boolean doInplaceRenameFor(PsiElement element, PsiElement context) {
        return JavaRefactoringSupportProvider.mayRenameInplace(element, context);
    }

    public RefactoringActionHandler getIntroduceVariableHandler() {
        return new IntroduceVariableHandler();
    }

    @Nullable
    public RefactoringActionHandler getExtractMethodHandler() {
        return new ExtractMethodHandler();
    }

    public RefactoringActionHandler getIntroduceParameterHandler() {
        return new IntroduceParameterHandler();
    }

    public RefactoringActionHandler getPullUpHandler() {
        return new JavaPullUpHandler();
    }

    public RefactoringActionHandler getPushDownHandler() {
        return new JavaPushDownHandler();
    }

    public RefactoringActionHandler getExtractModuleHandler() {
        return new ExtractInterfaceHandler();
    }

    public RefactoringActionHandler getExtractSuperClassHandler() {
        return new ExtractSuperclassHandler();
    }

    public static boolean mayRenameInplace(PsiElement elementToRename, PsiElement nameSuggestionContext) {
        if (!(elementToRename instanceof PsiVariable)) {
            return false;
        }
        if (nameSuggestionContext != null && nameSuggestionContext.getContainingFile() != elementToRename.getContainingFile()) {
            return false;
        }
        if (!(elementToRename instanceof PsiLocalVariable) && !(elementToRename instanceof PsiParameter)) {
            return false;
        }
        SearchScope useScope = elementToRename.getUseScope();
        if (!(useScope instanceof LocalSearchScope)) {
            return false;
        }
        PsiElement[] scopeElements = ((LocalSearchScope)useScope).getScope();
        if (scopeElements.length > 1 && !JavaRefactoringSupportProvider.isElementWithComment(scopeElements)) {
            return false;
        }
        PsiFile containingFile = elementToRename.getContainingFile();
        return PsiTreeUtil.isAncestor((PsiElement)containingFile, (PsiElement)scopeElements[0], (boolean)false);
    }

    private static boolean isElementWithComment(PsiElement[] scopeElements) {
        if (scopeElements.length > 2) {
            return false;
        }
        PsiDocComment comment = null;
        PsiDocCommentOwner owner = null;
        for (PsiElement element : scopeElements) {
            if (element instanceof PsiDocComment) {
                comment = (PsiDocComment)element;
                continue;
            }
            if (!(element instanceof PsiDocCommentOwner)) continue;
            owner = (PsiDocCommentOwner)element;
        }
        return comment != null && comment.getOwner() == owner;
    }
}

